/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.PivotPointAverage$Signals;
import com.motivewave.platform.study.overlay.PivotPointAverage$Values;

@StudyHeader(namespace="com.motivewave", id="ID_PPAV", rb="com.motivewave.platform.study.nls.strings2", name="NAME_PIVOT_POINT_AVERAGE", label="LBL_PPAV", desc="DESC_PPAV", helpLink="http://www.motivewave.com/studies/pivot_point_average.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class PivotPointAverage
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("SMOOTH_PERIOD", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PRICE_METHOD", new Object[0]), 1, 1, 3, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PP", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("PPAV", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("PP", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("PPAV", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PivotPointAverage$Values.PPAV, this.get("LBL_PPAV", new Object[0]), new String[]{"method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PivotPointAverage$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PivotPointAverage$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)PivotPointAverage$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)PivotPointAverage$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)PivotPointAverage$Values.PP, "line");
        runtimeDescriptor.declarePath((Object)PivotPointAverage$Values.PPAV, "line2");
        runtimeDescriptor.declareIndicator((Object)PivotPointAverage$Values.PP, "ind");
        runtimeDescriptor.declareIndicator((Object)PivotPointAverage$Values.PPAV, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{PivotPointAverage$Values.PP, PivotPointAverage$Values.PPAV});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, (Object)Enums.BarInput.OPEN, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.HIGH, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.LOW, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.CLOSE, 0.0);
        double d6 = (d3 + d4 + d5) / 3.0;
        if (n4 == 1) {
            d6 = (d3 + d4 + d5) / 3.0;
        }
        if (n4 == 2) {
            d6 = (d3 + d4 + d5 + d2) / 4.0;
        }
        if (n4 == 3) {
            d6 = (d3 + d4 + d2) / 3.0;
        }
        dataSeries.setDouble(n2, (Object)PivotPointAverage$Values.PP, Double.valueOf(d6));
        if (n2 < n3 + 1) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)PivotPointAverage$Values.PP);
        dataSeries.setDouble(n2, (Object)PivotPointAverage$Values.PPAV, d7);
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)PivotPointAverage$Values.PP, (Object)PivotPointAverage$Values.PPAV);
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)PivotPointAverage$Values.PP, (Object)PivotPointAverage$Values.PPAV);
        dataSeries.setBoolean(n2, (Object)PivotPointAverage$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)PivotPointAverage$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PP", new Object[]{Util.round((double)d6, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)PivotPointAverage$Signals.SELL, string, (Object)d6);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PP", new Object[]{Util.round((double)d6, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)PivotPointAverage$Signals.BUY, string, (Object)d6);
        }
        dataSeries.setComplete(n2);
    }
}

