/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.overlay.NewMarketParadigmContraction$Signals;
import com.motivewave.platform.study.overlay.NewMarketParadigmContraction$Values;

@StudyHeader(namespace="com.motivewave", id="ID_NMPC", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_NMPC", label="LBL_NMPC", name="NAME_NEW_MARKET_PARADIGM_CONTRACTION", helpLink="http://www.motivewave.com/studies/new_market_paradigm_contraction.htm", overlay=true, signals=true, studyOverlay=true)
public class NewMarketParadigmContraction
extends Study {
    static final String a = "StdDevUp";
    static final String b = "StdDevDown";
    static final String c = "Path5";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 28, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("STD_DEV_UP", new Object[0]), 2.0, 0.1, 10.1, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("STD_DEV_DOWN", new Object[0]), 2.0, 0.1, 10.1, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("BB_TOP", new Object[0]), defaults.getLineColor(), 0.0125f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line4", this.get("BB_BOTTOM", new Object[0]), defaults.getLineColor(), 0.0125f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("SMA", new Object[0]), defaults.getLineColor(), 0.01f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NewMarketParadigmContraction$Values.UP, this.get("LBL_NMPC", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NewMarketParadigmContraction$Values.DOWN, this.get("LBL_NMPC", new Object[0]), new String[]{"input", "period", b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NewMarketParadigmContraction$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NewMarketParadigmContraction$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)NewMarketParadigmContraction$Values.UP, "line");
        runtimeDescriptor.declarePath((Object)NewMarketParadigmContraction$Values.DOWN, "line2");
        runtimeDescriptor.declarePath((Object)NewMarketParadigmContraction$Values.BB_TOP, "line3");
        runtimeDescriptor.declarePath((Object)NewMarketParadigmContraction$Values.BB_BOTT, "line4");
        runtimeDescriptor.declarePath((Object)NewMarketParadigmContraction$Values.SMA, c);
        runtimeDescriptor.declareIndicator((Object)NewMarketParadigmContraction$Values.UP, "ind");
        runtimeDescriptor.declareIndicator((Object)NewMarketParadigmContraction$Values.DOWN, "ind2");
        runtimeDescriptor.declareSignal((Object)NewMarketParadigmContraction$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)NewMarketParadigmContraction$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{NewMarketParadigmContraction$Values.UP, NewMarketParadigmContraction$Values.DOWN, NewMarketParadigmContraction$Values.BB_TOP, NewMarketParadigmContraction$Values.BB_BOTT, NewMarketParadigmContraction$Values.SMA});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        boolean bl2;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3 + 1) {
            return;
        }
        double d2 = this.getSettings().getDouble(a);
        double d3 = this.getSettings().getDouble(b);
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = 0;
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double[] dArray = n.a(dataSeries, n2, n3, d2, d3, object);
        double[] dArray2 = n.a(dataSeries, n2 - 1, n3, d2, d3, object);
        double d5 = dArray[0];
        double d6 = dArray[1];
        boolean bl3 = d5 < dArray2[0] && d6 > dArray2[1];
        boolean bl4 = d5 > dArray2[0] && d6 < dArray2[1];
        boolean bl5 = bl2 = !bl3 && !bl4;
        if (bl3) {
            n4 = 1;
        }
        if (bl4) {
            n4 = 2;
        }
        if (bl2) {
            n4 = 3;
        }
        if (n4 == 1) {
            dataSeries.setDouble(n2, (Object)NewMarketParadigmContraction$Values.UP, Double.valueOf(d5));
            dataSeries.setDouble(n2, (Object)NewMarketParadigmContraction$Values.DOWN, Double.valueOf(d6));
        }
        dataSeries.setDouble(n2, (Object)NewMarketParadigmContraction$Values.BB_TOP, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)NewMarketParadigmContraction$Values.BB_BOTT, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)NewMarketParadigmContraction$Values.SMA, Double.valueOf(dArray[2]));
        boolean bl6 = d4 > dArray[0];
        boolean bl7 = d4 < dArray[1];
        dataSeries.setBoolean(n2, (Object)NewMarketParadigmContraction$Signals.SELL, Boolean.valueOf(bl6));
        dataSeries.setBoolean(n2, (Object)NewMarketParadigmContraction$Signals.BUY, Boolean.valueOf(bl7));
        if (bl6) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_NMPC_PRICE_TOP", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)NewMarketParadigmContraction$Signals.SELL, string, (Object)d4);
        }
        if (bl7) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_NMPC_PRICE_BOTTOM", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)NewMarketParadigmContraction$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

