/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.NarrowSidewaysCh$Signals;
import com.motivewave.platform.study.overlay.NarrowSidewaysCh$Values;

@StudyHeader(namespace="com.motivewave", id="ID_NSWCH", rb="com.motivewave.platform.study.nls.strings2", name="NAME_NARROW_SIDEWAYS_CHANNEL", label="LBL_NSC", desc="DESC_NSC", helpLink="http://www.motivewave.com/studies/narrow_sideways_channel.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class NarrowSidewaysCh
extends Study {
    static final String a = "Input3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 2, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor("input2", this.get("STD_DEV_FACTOR", new Object[0]), 3.0, 0.1, 10.1, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("RANGE", new Object[0]), 0.0, 0.0, 9999.1, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("TOP", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("TOP", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("BOTTOM", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "input2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NarrowSidewaysCh$Values.NSC_TOP, this.get("NSCT", new Object[0]), new String[]{"input", "method", "input", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NarrowSidewaysCh$Values.NSC_BOTTOM, this.get("NSCB", new Object[0]), new String[]{"input", "method", "input", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NarrowSidewaysCh$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NarrowSidewaysCh$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)NarrowSidewaysCh$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)NarrowSidewaysCh$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)NarrowSidewaysCh$Values.NSC_TOP, "line");
        runtimeDescriptor.declarePath((Object)NarrowSidewaysCh$Values.NSC_BOTTOM, "line2");
        runtimeDescriptor.declareIndicator((Object)NarrowSidewaysCh$Values.NSC_TOP, "ind");
        runtimeDescriptor.declareIndicator((Object)NarrowSidewaysCh$Values.NSC_BOTTOM, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{NarrowSidewaysCh$Values.NSC_TOP, NarrowSidewaysCh$Values.NSC_BOTTOM});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    public void onBarUpdate(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        this.clearFigures();
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        double d2 = this.getSettings().getDouble("input2");
        double d3 = this.getSettings().getDouble(a);
        int n2 = this.getSettings().getInteger("period");
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        Double d9 = null;
        int n3 = n2;
        int n4 = dataSeries.getEndIndex();
        for (int i2 = n2; i2 <= n4; ++i2) {
            if (i2 < n3 || (d9 = dataSeries.ma(mAMethod, i2, n2, object)) == null) continue;
            d6 = dataSeries.std(i2, n2, object);
            d7 = d9 + d6 * d2;
            d8 = d9 - d6 * d2;
            for (int i3 = i2 - (n2 - 1); i3 <= i2; ++i3) {
                String string;
                MarkerInfo markerInfo;
                Coordinate coordinate;
                dataSeries.setDouble(i3, (Object)NarrowSidewaysCh$Values.NSC_TOP, Double.valueOf(d7));
                dataSeries.setDouble(i3, (Object)NarrowSidewaysCh$Values.NSC_BOTTOM, Double.valueOf(d8));
                d4 = dataSeries.getHigh(i3);
                d5 = dataSeries.getLow(i3);
                boolean bl2 = d4 - d5 >= d3 && d4 > d7;
                boolean bl3 = d4 - d5 >= d3 && d5 < d8;
                dataSeries.setBoolean(i3, (Object)NarrowSidewaysCh$Signals.SELL, Boolean.valueOf(bl2));
                dataSeries.setBoolean(i3, (Object)NarrowSidewaysCh$Signals.BUY, Boolean.valueOf(bl3));
                if (bl2) {
                    coordinate = new Coordinate(dataSeries.getStartTime(i3), d4);
                    markerInfo = this.getSettings().getMarker("downMarker");
                    string = this.get("SELL_NSC_HIGH", new Object[]{Util.round((double)d4, (int)2)});
                    if (markerInfo.isEnabled()) {
                        this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
                    }
                    dataContext.signal(i3, (Object)NarrowSidewaysCh$Signals.SELL, string, (Object)d4);
                }
                if (bl3) {
                    coordinate = new Coordinate(dataSeries.getStartTime(i3), d5);
                    markerInfo = this.getSettings().getMarker("upMarker");
                    string = this.get("BUY_NSC_LOW", new Object[]{Util.round((double)d5, (int)2)});
                    if (markerInfo.isEnabled()) {
                        this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
                    }
                    dataContext.signal(i3, (Object)NarrowSidewaysCh$Signals.BUY, string, (Object)d5);
                }
                dataSeries.setComplete(i3);
            }
            n3 = i2 + n2;
            if (n3 <= n4) continue;
            n2 = n4 - i2;
            n3 = n4;
        }
    }
}

