/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.overlay.LinearRegression$Values;

@StudyHeader(namespace="com.motivewave", id="ID_LIN_REG", rb="com.motivewave.platform.study.nls.strings2", name="NAME_LINEAR_REGRESSION", label="LBL_LGL", desc="DESC_LINEAR_REG", helpLink="http://www.motivewave.com/studies/linear_regression.htm", overlay=true, studyOverlay=true)
public class LinearRegression
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("bar", this.get("REGRESSION_BARS", new Object[0]), 40, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("bars", this.get("FUTURE_BARS", new Object[0]), 1, 0, 10, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.declarePath((Object)LinearRegression$Values.LINREG, "line");
        runtimeDescriptor.setLabelSettings(new String[]{"input", "bar", "bars"});
        runtimeDescriptor.setRangeKeys(new Object[]{LinearRegression$Values.LINREG});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("bar");
        this.setMinBars(n2);
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        this.clearFigures();
        int n2 = dataSeries.size() - 1;
        int n3 = this.getSettings().getInteger("bar");
        if (n3 > n2) {
            n3 = n2;
        }
        int n4 = n2 - n3;
        int n5 = this.getSettings().getInteger("bars");
        Object object = this.getSettings().getInput("input");
        double[] dArray = n.a(dataSeries, n2, n3, object, 0);
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = d2 + d3 * 0.0;
        double d5 = d2 + d3 * (double)n3;
        if (this.getSettings().getPath("line").isEnabled()) {
            PathInfo pathInfo = this.getSettings().getPath("line");
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n4), d4);
            Coordinate coordinate2 = new Coordinate(dataSeries.getStartTime(n2), d5);
            Line line = new Line(coordinate, coordinate2, pathInfo);
            line.setExtendRight(n5);
            this.addFigure((Figure)line);
        }
    }
}

