/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.overlay.LaguerreFilterAdaptive$Values;

@StudyHeader(namespace="com.motivewave", id="ID_LAGFA", rb="com.motivewave.platform.study.nls.strings2", label="LBL_LAGFA", name="NAME_LAGUERRE_FILTER_ADAPTIVE", desc="DESC_LAGFA", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/laguerre_filter_adaptive.htm", signals=false, overlay=true, studyOverlay=true)
public class LaguerreFilterAdaptive
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 5, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LAGFA", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LaguerreFilterAdaptive$Values.FILT, this.get("LBL_LAGFA", new Object[0]), new String[]{"input", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)LaguerreFilterAdaptive$Values.FILT, "line");
        runtimeDescriptor.declareIndicator((Object)LaguerreFilterAdaptive$Values.FILT, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{LaguerreFilterAdaptive$Values.FILT});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = dataSeries.getDouble(n2, object, 0.0);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilterAdaptive$Values.FILT, d5);
        double d7 = Math.abs(d5 - d6);
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.DIFF, Double.valueOf(d7));
        if (n2 < n3 + 1) {
            return;
        }
        double d8 = dataSeries.highest(n2, n3, (Object)LaguerreFilterAdaptive$Values.DIFF);
        if (d8 - (d2 = dataSeries.lowest(n2, n3, (Object)LaguerreFilterAdaptive$Values.DIFF).doubleValue()) != 0.0) {
            d4 = (d7 - d2) / (d8 - d2);
        }
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.MID, Double.valueOf(d4));
        if (n2 < n3 + n4 + 1) {
            return;
        }
        if (d8 - d2 != 0.0) {
            d3 = n.e(dataSeries, n2, n4, (Object)LaguerreFilterAdaptive$Values.MID);
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilterAdaptive$Values.L0, d5);
        double d10 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilterAdaptive$Values.L1, d5);
        double d11 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilterAdaptive$Values.L2, d5);
        double d12 = dataSeries.getDouble(n2 - 1, (Object)LaguerreFilterAdaptive$Values.L3, d5);
        double d13 = d3 * d5 + (1.0 - d3) * d9;
        double d14 = -(1.0 - d3) * d13 + d9 + (1.0 - d3) * d10;
        double d15 = -(1.0 - d3) * d14 + d10 + (1.0 - d3) * d11;
        double d16 = -(1.0 - d3) * d15 + d11 + (1.0 - d3) * d12;
        double d17 = (d13 + 2.0 * d14 + 2.0 * d15 + d16) / 6.0;
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.FILT, Double.valueOf(d17));
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.L0, Double.valueOf(d13));
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.L1, Double.valueOf(d14));
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.L2, Double.valueOf(d15));
        dataSeries.setDouble(n2, (Object)LaguerreFilterAdaptive$Values.L3, Double.valueOf(d16));
        dataSeries.setComplete(n2);
    }
}

