/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.KaseIndicator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_KI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_KASE_INDICATOR", label="LBL_KI", desc="DESC_KI", helpLink="http://www.motivewave.com/studies/kase_indicator.htm", requiresVolume=true, signals=false, overlay=true, studyOverlay=true)
public class KaseIndicator
extends Study {
    static final String a = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH1", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("PATH2", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("PATH3", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND1", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("IND2", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("IND3", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KaseIndicator$Values.PLOT1, this.get("PLOT1", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KaseIndicator$Values.PLOT2, this.get("PLOT2", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KaseIndicator$Values.PLOT3, this.get("PLOT3", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)KaseIndicator$Values.PLOT1, "line");
        runtimeDescriptor.declarePath((Object)KaseIndicator$Values.PLOT2, "line2");
        runtimeDescriptor.declarePath((Object)KaseIndicator$Values.PLOT3, "line3");
        runtimeDescriptor.declareIndicator((Object)KaseIndicator$Values.PLOT1, "ind");
        runtimeDescriptor.declareIndicator((Object)KaseIndicator$Values.PLOT2, "ind2");
        runtimeDescriptor.declareIndicator((Object)KaseIndicator$Values.PLOT3, a);
        runtimeDescriptor.setRangeKeys(new Object[]{KaseIndicator$Values.PLOT1, KaseIndicator$Values.PLOT2, KaseIndicator$Values.PLOT3});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getHigh(n2 - n3);
        double d5 = dataSeries.getLow(n2 - n3);
        double d6 = dataSeries.sma(n2, n3, (Object)Enums.BarInput.VOLUME);
        double d7 = dataSeries.atr(n2, n3);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)KaseIndicator$Values.KUP, 0.0);
        if (d7 > 0.0) {
            d8 = d4 / d3 / (d6 * Math.sqrt(n3));
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)KaseIndicator$Values.KDOWN, 0.0);
        if (d7 > 0.0) {
            d9 = d2 / d5 / (d6 * Math.sqrt(n3));
        }
        Double d10 = null;
        if (d8 > d9) {
            d10 = d3;
        }
        Double d11 = null;
        if (d8 < d9) {
            d11 = d2;
        }
        Double d12 = null;
        if (d8 == d9) {
            d12 = (d2 + d3) / 2.0;
        }
        dataSeries.setDouble(n2, (Object)KaseIndicator$Values.KUP, Double.valueOf(d8));
        dataSeries.setDouble(n2, (Object)KaseIndicator$Values.KDOWN, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)KaseIndicator$Values.PLOT1, d10);
        dataSeries.setDouble(n2, (Object)KaseIndicator$Values.PLOT2, d11);
        dataSeries.setDouble(n2, (Object)KaseIndicator$Values.PLOT3, d12);
        dataSeries.setComplete(n2);
    }
}

