/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.IchimokuKinkoHyo$Signals;
import com.motivewave.platform.study.overlay.IchimokuKinkoHyo$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ICHIMOKU", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ICHIMOKU", label="LBL_ICHIMOKU", desc="DESC_ICHIMOKU", menu="MENU_OVERLAY", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/ichimoku_kinko_hyo.htm")
public class IchimokuKinkoHyo
extends Study {
    static final String a = "tsLine";
    static final String b = "ksLine";
    static final String c = "csLine";
    static final String d = "ssaLine";
    static final String e = "ssbLine";
    static final String f = "tsInd";
    static final String g = "ksInd";
    static final String h = "csInd";
    static final String i = "ssaInd";
    static final String j = "ssbInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_TENKAN_SEN", new Object[0]), 9, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_KIJUN_SEN", new Object[0]), 26, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("LBL_SENKOU_SPANB", new Object[0]), 52, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_TS_LINE", new Object[0]), defaults.getOrange(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("LBL_KS_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("LBL_CS_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("LBL_SSA_LINE", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(e, this.get("LBL_SSB_LINE", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_KUMO_UP", new Object[0]), d, e, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_KUMO_DOWN", new Object[0]), d, e, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup3);
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_TS_IND", new Object[0]), defaults.getOrange(), Color.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_KS_IND", new Object[0]), defaults.getRed(), Color.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor(h, this.get("LBL_CS_IND", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor(i, this.get("LBL_SSA_IND", new Object[0]), defaults.getGreen(), Color.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor(j, this.get("LBL_SSB_IND", new Object[0]), defaults.getGreen(), Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IchimokuKinkoHyo$Values.TS, this.get("LBL_TENKAN_SEN", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IchimokuKinkoHyo$Values.KS, this.get("LBL_KIJUN_SEN", new Object[0]), new String[]{"period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IchimokuKinkoHyo$Values.CS, this.get("LBL_CHIKOU_SPAN", new Object[0]), new String[]{"period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IchimokuKinkoHyo$Values.SSA, this.get("LBL_SENKOU_SPANA", new Object[0]), new String[]{"input", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IchimokuKinkoHyo$Values.SSB, this.get("LBL_SENKOU_SPANB", new Object[0]), new String[]{"input", "period2", "period3"}));
        runtimeDescriptor.declarePath((Object)IchimokuKinkoHyo$Values.TS, a);
        runtimeDescriptor.declarePath((Object)IchimokuKinkoHyo$Values.KS, b);
        runtimeDescriptor.declarePath((Object)IchimokuKinkoHyo$Values.CS, c);
        runtimeDescriptor.declarePath((Object)IchimokuKinkoHyo$Values.SSA, d);
        runtimeDescriptor.declarePath((Object)IchimokuKinkoHyo$Values.SSB, e);
        runtimeDescriptor.declareIndicator((Object)IchimokuKinkoHyo$Values.TS, f);
        runtimeDescriptor.declareIndicator((Object)IchimokuKinkoHyo$Values.KS, g);
        runtimeDescriptor.declareIndicator((Object)IchimokuKinkoHyo$Values.CS, h);
        runtimeDescriptor.declareIndicator((Object)IchimokuKinkoHyo$Values.SSA, i);
        runtimeDescriptor.declareIndicator((Object)IchimokuKinkoHyo$Values.SSB, j);
        runtimeDescriptor.setRangeKeys(new Object[]{IchimokuKinkoHyo$Values.TS, IchimokuKinkoHyo$Values.KS, IchimokuKinkoHyo$Values.CS, IchimokuKinkoHyo$Values.SSA, IchimokuKinkoHyo$Values.SSB});
        runtimeDescriptor.declareSignal((Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_ABOVE_KIJUN, this.get("TENKAN_CROSS_ABOVE_KIJUN", new Object[0]));
        runtimeDescriptor.declareSignal((Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_BELOW_KIJUN, this.get("TENKAN_CROSS_BELOW_KIJUN", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public boolean isRepaintAllOnUpdate() {
        return true;
    }

    public int getMinBars() {
        int n2 = this.getSettings().getInteger("period2");
        return Util.maxInt((int[])new int[]{this.getSettings().getInteger("period"), this.getSettings().getInteger("period2"), this.getSettings().getInteger("period3")}) + n2;
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2;
        double d3;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 >= n3) {
            d3 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
            d2 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
            dataSeries.setDouble(n2, (Object)IchimokuKinkoHyo$Values.TS, Double.valueOf((d3 + d2) / 2.0));
        }
        if (n2 >= n4) {
            d3 = dataSeries.highest(n2, n4, (Object)Enums.BarInput.HIGH);
            d2 = dataSeries.lowest(n2, n4, (Object)Enums.BarInput.LOW);
            dataSeries.setDouble(n2, (Object)IchimokuKinkoHyo$Values.KS, Double.valueOf((d3 + d2) / 2.0));
        }
        if (n2 >= n4) {
            dataSeries.setDouble(n2 - n4, (Object)IchimokuKinkoHyo$Values.CS, Double.valueOf(dataSeries.getClose(n2)));
        }
        if (n2 >= n5) {
            d3 = dataSeries.highest(n2, n5, (Object)Enums.BarInput.HIGH);
            d2 = dataSeries.lowest(n2, n5, (Object)Enums.BarInput.LOW);
            dataSeries.setDouble(n2 + n4, (Object)IchimokuKinkoHyo$Values.SSB, Double.valueOf((d3 + d2) / 2.0));
        }
        if (n2 <= n4) {
            return;
        }
        Double d4 = dataSeries.getDouble(n2, (Object)IchimokuKinkoHyo$Values.TS);
        Double d5 = dataSeries.getDouble(n2, (Object)IchimokuKinkoHyo$Values.KS);
        if (d4 == null || d5 == null) {
            return;
        }
        dataSeries.setDouble(n2 + n4, (Object)IchimokuKinkoHyo$Values.SSA, Double.valueOf((d4 + d5) / 2.0));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)IchimokuKinkoHyo$Values.TS, (Object)IchimokuKinkoHyo$Values.KS) && !dataSeries.getBoolean(n2, (Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_ABOVE_KIJUN, false)) {
            dataSeries.setBoolean(n2, (Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_ABOVE_KIJUN, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("TENKAN_CROSS_ABOVE", new Object[]{this.format(d4), this.format(d5), this.format(dataSeries.getClose(n2))});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_ABOVE_KIJUN, string, (Object)this.round(d4));
        } else if (this.crossedBelow(dataSeries, n2, (Object)IchimokuKinkoHyo$Values.TS, (Object)IchimokuKinkoHyo$Values.KS) && !dataSeries.getBoolean(n2, (Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_BELOW_KIJUN, false)) {
            dataSeries.setBoolean(n2, (Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_BELOW_KIJUN, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("TENKAN_CROSS_BELOW", new Object[]{this.format(d4), this.format(d5), this.format(dataSeries.getClose(n2))});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)IchimokuKinkoHyo$Signals.TENKAN_CROSS_BELOW_KIJUN, string, (Object)d4);
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

