/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.Envelopes$Signals;
import com.motivewave.platform.study.overlay.Envelopes$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ENVELOPES", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ENVELOPES", desc="DESC_ENVELOPES", label="LBL_ENVELOPES", menu="MENU_OVERLAY", overlay=true, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/envelopes.htm")
public class Envelopes
extends Study {
    static final String a = "deviation";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1), new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_DEVIATION", new Object[0]), 1.0, 0.01, 999.0, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("topLine", this.get("LBL_TOP_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("bottomLine", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("fill", this.get("LBL_FILL_COLOR", new Object[0]), "topLine", "bottomLine", Enums.ShadeType.BOTH, defaults.getFillColor(), false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup3);
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_CROSS_TOP_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingTab.addGroup(settingGroup4);
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_TOP_IND", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_BOTTOM_IND", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "shift", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Envelopes$Values.TOP, this.get("LBL_ENV_TOP", new Object[0]), new String[]{"input", "method", "period", "shift", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Envelopes$Values.BOTTOM, this.get("LBL_ENV_BOTTOM", new Object[0]), new String[]{"input", "method", "period", "shift", a}));
        runtimeDescriptor.declarePath((Object)Envelopes$Values.TOP, "topLine");
        runtimeDescriptor.declarePath((Object)Envelopes$Values.BOTTOM, "bottomLine");
        runtimeDescriptor.declareIndicator((Object)Envelopes$Values.TOP, "topInd");
        runtimeDescriptor.declareIndicator((Object)Envelopes$Values.BOTTOM, "bottomInd");
        runtimeDescriptor.setRangeKeys(new Object[]{Envelopes$Values.TOP, Envelopes$Values.BOTTOM});
        runtimeDescriptor.declareSignal((Object)Envelopes$Signals.CROSS_ABOVE_TOP_BAND, this.get("LBL_CROSS_TOP_BAND", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Envelopes$Signals.CROSS_BELOW_BOTTOM_BAND, this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculateValues(DataContext dataContext) {
        int n2;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("shift");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n5 = n2 = dataSeries.size() - 1;
        if (n4 < 0) {
            n5 -= n4;
        }
        double d2 = this.getSettings().getDouble(a) / 100.0;
        boolean bl2 = this.getSettings().isBarUpdates();
        for (int i2 = n3; i2 <= n5; ++i2) {
            Double d3;
            if (dataSeries.isComplete(i2 + n4) || !bl2 && !dataSeries.isBarComplete(i2) || (d3 = dataSeries.ma(this.getSettings().getMAMethod("method"), i2, n3, this.getSettings().getInput("input"))) == null) continue;
            dataSeries.setDouble(i2 + n4, (Object)Envelopes$Values.TOP, Double.valueOf(d3 * (1.0 + d2)));
            dataSeries.setDouble(i2 + n4, (Object)Envelopes$Values.BOTTOM, Double.valueOf(d3 * (1.0 - d2)));
            dataSeries.setComplete(i2 + n4, i2 >= 0 && i2 < n2);
            this.a(dataContext, i2);
            this.b(dataContext, i2);
        }
    }

    private void a(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)Envelopes$Values.TOP);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedAbove(dataSeries, n2, Enums.BarInput.CLOSE, (Object)Envelopes$Values.TOP) && !dataSeries.getBoolean(n2, (Object)Envelopes$Signals.CROSS_ABOVE_TOP_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)Envelopes$Signals.CROSS_ABOVE_TOP_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("CROSS_ABOVE_TOP_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)Envelopes$Signals.CROSS_ABOVE_TOP_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }

    private void b(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)Envelopes$Values.BOTTOM);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedBelow(dataSeries, n2, Enums.BarInput.CLOSE, (Object)Envelopes$Values.BOTTOM) && !dataSeries.getBoolean(n2, (Object)Envelopes$Signals.CROSS_BELOW_BOTTOM_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)Envelopes$Signals.CROSS_BELOW_BOTTOM_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("CROSS_BELOW_BOTTOM_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)Envelopes$Signals.CROSS_BELOW_BOTTOM_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }
}

