/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.EhlersFilter$Values;

@StudyHeader(namespace="com.motivewave", id="ID_EHLF", rb="com.motivewave.platform.study.nls.strings2", label="LBL_EHLF", name="NAME_EHLERS_FILTER", desc="DESC_EHLF", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/ehlers_filter.htm", signals=false, overlay=true, studyOverlay=true)
public class EhlersFilter
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("MOMENTUM_LENGTH", new Object[0]), 5, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_EHLF", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EhlersFilter$Values.FILT, this.get("LBL_EHLF", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)EhlersFilter$Values.FILT, "line");
        runtimeDescriptor.declareIndicator((Object)EhlersFilter$Values.FILT, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{EhlersFilter$Values.FILT});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4;
        int n5 = this.getSettings().getInteger("period");
        if (n2 < Math.max(n5, n4 = this.getSettings().getInteger("period2").intValue())) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[] dArray = new double[n5];
        int n6 = 0;
        for (n3 = n2 - (n5 - 1); n3 <= n2; ++n3) {
            d2 = dataSeries.getDouble(n3, object, 0.0);
            d3 = dataSeries.getDouble(n3 - n4, object, 0.0);
            dArray[n6] = Math.abs(d2 - d3);
            ++n6;
        }
        n6 = 0;
        for (n3 = n2 - (n5 - 1); n3 <= n2; ++n3) {
            d2 = dataSeries.getDouble(n3, object, 0.0);
            d4 += dArray[n6] * d2;
            d5 += dArray[n6];
            ++n6;
        }
        double d6 = d4 / d5;
        dataSeries.setDouble(n2, (Object)EhlersFilter$Values.FILT, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

