/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.DonchianChannel$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="DON_CHANNEL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_DON_CHANNEL", menu="MENU_OVERLAY", desc="DESC_DON_CHANNEL", label="LBL_DON_CHANNEL", overlay=true, helpLink="http://www.motivewave.com/studies/donchian_channel.htm")
public class DonchianChannel
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("topLine", this.get("LBL_TOP_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), defaults.getLineColor(), 1.0f, new float[]{3.0f, 3.0f}, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("bottomLine", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_TOP_IND", new Object[0]), Color.WHITE, Color.BLACK, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("middleInd", this.get("LBL_MIDDLE_IND", new Object[0]), Color.WHITE, Color.BLACK, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_BOTTOM_IND", new Object[0]), defaults.getRed(), Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "shift"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DonchianChannel$Values.TOP, this.get("LBL_DC_TOP", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DonchianChannel$Values.MIDDLE, this.get("LBL_DC_MIDDLE", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DonchianChannel$Values.BOTTOM, this.get("LBL_DC_BOTTOM", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)DonchianChannel$Values.TOP, "topLine");
        runtimeDescriptor.declarePath((Object)DonchianChannel$Values.MIDDLE, "middleLine");
        runtimeDescriptor.declarePath((Object)DonchianChannel$Values.BOTTOM, "bottomLine");
        runtimeDescriptor.declareIndicator((Object)DonchianChannel$Values.TOP, "topInd");
        runtimeDescriptor.declareIndicator((Object)DonchianChannel$Values.MIDDLE, "middleInd");
        runtimeDescriptor.declareIndicator((Object)DonchianChannel$Values.BOTTOM, "bottomInd");
        runtimeDescriptor.setRangeKeys(new Object[]{DonchianChannel$Values.TOP, DonchianChannel$Values.BOTTOM});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = this.getSettings().getInteger("shift");
        if (n2 < n3) {
            return;
        }
        Double d2 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        Double d3 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        Double d4 = null;
        if (d2 != null && d3 != null) {
            d4 = (d2 + d3) / 2.0;
        }
        dataSeries.setDouble(n2 + n4, (Object)DonchianChannel$Values.TOP, d2);
        dataSeries.setDouble(n2 + n4, (Object)DonchianChannel$Values.MIDDLE, d4);
        dataSeries.setDouble(n2 + n4, (Object)DonchianChannel$Values.BOTTOM, d3);
        dataSeries.setComplete(n2, n2 >= 0 && dataSeries.isBarComplete(n2));
    }
}

