/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.DarvasBox$Signals;

@StudyHeader(namespace="com.motivewave", id="ID_DARVAS", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DARVAS_BOX", label="LBL_DARVAS", desc="DESC_DARVAS", menu="MENU_OVERLAYS", helpLink="http://www.motivewave.com/studies/darvas_box.htm", requiresVolume=false, signals=true, overlay=true, studyOverlay=true)
public class DarvasBox
extends Study {
    private Figure a;
    private Figure b;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUT", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 4, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("BOX", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("BOX", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DarvasBox$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DarvasBox$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)DarvasBox$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DarvasBox$Signals.BUY, this.get("BUY", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 4);
    }

    public void onBarUpdate(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        int n2 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        this.clearFigures();
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = dataSeries.getEndIndex() - 1;
        for (int i2 = 0; i2 <= n7; ++i2) {
            d2 = dataSeries.getHigh(i2);
            d3 = dataSeries.getLow(i2);
            if (++n5 >= n2) {
                n3 = 2;
            }
            if (n5 >= n2 * 2) {
                n3 = 3;
                ++n6;
            }
            if (n5 >= n2 * 2 && n6 >= n2) {
                n3 = 4;
            }
            if (n5 >= n2 * 2 && n6 >= n2 * 2) {
                n3 = 5;
            }
            if (d2 > d4) {
                if (n3 == 5) {
                    this.a(dataSeries, n4, d4, i2, d5);
                    this.a(dataContext, i2, d2, true);
                    n3 = 1;
                    d4 = 0.0;
                    n5 = 0;
                    n6 = 0;
                    continue;
                }
                d4 = d2;
                d5 = d3;
                n4 = i2;
                n3 = 1;
                n5 = 0;
                n6 = 0;
                continue;
            }
            if (d3 < d5) {
                if (n3 == 5) {
                    this.a(dataSeries, n4, d4, i2, d5);
                    this.a(dataContext, i2, d3, false);
                    n3 = 1;
                    d4 = 0.0;
                    n5 = 0;
                    n6 = 0;
                    continue;
                }
                d5 = d3;
                n6 = 0;
            }
            if (n3 == 2) {
                this.a(dataSeries, n4, i2, d4);
            }
            if (n3 == 3) {
                this.a(dataSeries, n4, i2, d4);
            }
            if (n3 == 3) {
                this.b(dataSeries, n4, i2, d5);
            }
            if (n3 != 4) continue;
            this.b(dataSeries, n4, i2, d5);
        }
    }

    protected void a(DataContext dataContext, int n2, double d2, boolean bl2) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        DataSeries dataSeries = dataContext.getDataSeries();
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_DARVAS_BOX_HIGH", new Object[]{Util.round((double)d2, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DarvasBox$Signals.SELL, string, (Object)d2);
        }
        if (!bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_DARVAS_BOX_LOW", new Object[]{Util.round((double)d2, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DarvasBox$Signals.BUY, string, (Object)d2);
        }
    }

    protected void a(DataSeries dataSeries, int n2, double d2, int n3, double d3) {
        if (this.getSettings().getPath("line").isEnabled()) {
            if (this.a != null) {
                this.removeFigure(this.a);
            }
            if (this.b != null) {
                this.removeFigure(this.b);
            }
            PathInfo pathInfo = this.getSettings().getPath("line");
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            Coordinate coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d2);
            Line line = new Line(coordinate, coordinate2, pathInfo);
            this.addFigure((Figure)line);
            coordinate = new Coordinate(dataSeries.getStartTime(n3), d2);
            coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d3);
            line = new Line(coordinate, coordinate2, pathInfo);
            this.addFigure((Figure)line);
            coordinate = new Coordinate(dataSeries.getStartTime(n3), d3);
            coordinate2 = new Coordinate(dataSeries.getStartTime(n2), d3);
            line = new Line(coordinate, coordinate2, pathInfo);
            this.addFigure((Figure)line);
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3);
            coordinate2 = new Coordinate(dataSeries.getStartTime(n2), d2);
            line = new Line(coordinate, coordinate2, pathInfo);
            this.addFigure((Figure)line);
        }
    }

    protected void a(DataSeries dataSeries, int n2, int n3, double d2) {
        if (this.getSettings().getPath("line").isEnabled()) {
            PathInfo pathInfo = this.getSettings().getPath("line");
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            Coordinate coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d2);
            if (this.a != null) {
                this.removeFigure(this.a);
            }
            Line line = new Line(coordinate, coordinate2, pathInfo);
            this.a = line;
            this.addFigure((Figure)line);
        }
    }

    protected void b(DataSeries dataSeries, int n2, int n3, double d2) {
        if (this.getSettings().getPath("line").isEnabled()) {
            PathInfo pathInfo = this.getSettings().getPath("line");
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            Coordinate coordinate2 = new Coordinate(dataSeries.getStartTime(n3), d2);
            if (this.b != null) {
                this.removeFigure(this.b);
            }
            Line line = new Line(coordinate, coordinate2, pathInfo);
            this.b = line;
            this.addFigure((Figure)line);
        }
    }
}

