/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.BuffAverage$Signals;
import com.motivewave.platform.study.overlay.BuffAverage$Values;

@StudyHeader(namespace="com.motivewave", id="ID_BUFF_AV", rb="com.motivewave.platform.study.nls.strings2", name="NAME_BUFF_AVERAGES", label="LBL_BA", desc="DESC_BUFF", menu="MENU_MOVING_AVERAGE", helpLink="http://www.motivewave.com/studies/buff_averages.htm", requiresVolume=true, signals=true, overlay=true, studyOverlay=true)
public class BuffAverage
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FAST_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SLOW_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("FAST", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SLOW", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("FAST", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SLOW", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BuffAverage$Values.FAST_BUFF, this.get("FBA", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BuffAverage$Values.SLOW_BUFF, this.get("SBA", new Object[0]), new String[]{"input", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BuffAverage$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BuffAverage$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)BuffAverage$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)BuffAverage$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)BuffAverage$Values.FAST_BUFF, "line");
        runtimeDescriptor.declarePath((Object)BuffAverage$Values.SLOW_BUFF, "line2");
        runtimeDescriptor.declareIndicator((Object)BuffAverage$Values.FAST_BUFF, "ind");
        runtimeDescriptor.declareIndicator((Object)BuffAverage$Values.SLOW_BUFF, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{BuffAverage$Values.FAST_BUFF, BuffAverage$Values.SLOW_BUFF});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3));
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getVolume(n2);
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        dataSeries.setDouble(n2, (Object)BuffAverage$Values.PRICE_VOL, Double.valueOf(d3 * d2));
        if (n2 < Math.max(n3, n4)) {
            return;
        }
        double d4 = dataSeries.sum(n2, n3, (Object)BuffAverage$Values.PRICE_VOL);
        double d5 = dataSeries.sum(n2, n3, (Object)Enums.BarInput.VOLUME);
        double d6 = 0.0;
        if (d5 > 0.0) {
            d6 = d4 / d5;
        }
        dataSeries.setDouble(n2, (Object)BuffAverage$Values.FAST_BUFF, Double.valueOf(d6));
        d4 = dataSeries.sum(n2, n4, (Object)BuffAverage$Values.PRICE_VOL);
        d5 = dataSeries.sum(n2, n4, (Object)Enums.BarInput.VOLUME);
        double d7 = 0.0;
        if (d5 > 0.0) {
            d7 = d4 / d5;
        }
        dataSeries.setDouble(n2, (Object)BuffAverage$Values.SLOW_BUFF, Double.valueOf(d7));
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)BuffAverage$Values.FAST_BUFF, (Object)BuffAverage$Values.SLOW_BUFF);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)BuffAverage$Values.FAST_BUFF, (Object)BuffAverage$Values.SLOW_BUFF);
        dataSeries.setBoolean(n2, (Object)BuffAverage$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)BuffAverage$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_FAST_BUFF", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)BuffAverage$Signals.SELL, string, (Object)d3);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_FAST_BUFF", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)BuffAverage$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

