/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.BidAskSpread$Values;

@StudyHeader(namespace="com.motivewave", id="BID_ASK", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BID_ASK", desc="DESC_BID_ASK", label="LBL_BID_ASK", menu="MENU_OVERLAY", helpLink="http://www.motivewave.com/studies/bid_ask_spread.htm", overlay=true, requiresBidAskHistory=true)
public class BidAskSpread
extends Study {
    static final String a = "askLine";
    static final String b = "bidLine";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object[])new Enums.BarInput[]{Enums.BarInput.OPEN, Enums.BarInput.HIGH, Enums.BarInput.LOW, Enums.BarInput.CLOSE}, (Object)Enums.BarInput.CLOSE)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("LBL_BID_LINE", new Object[0]), defaults.getBlueLine(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_ASK_LINE", new Object[0]), defaults.getRedLine(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BidAskSpread$Values.BID, this.get("LBL_BID", new Object[0]), new String[]{"input"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BidAskSpread$Values.ASK, this.get("LBL_ASK", new Object[0]), new String[]{"input"}));
        runtimeDescriptor.declarePath((Object)BidAskSpread$Values.BID, b);
        runtimeDescriptor.declarePath((Object)BidAskSpread$Values.ASK, a);
        runtimeDescriptor.setRangeKeys(new Object[]{BidAskSpread$Values.BID, BidAskSpread$Values.ASK});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        if (barInput == null) {
            barInput = Enums.BarInput.CLOSE;
        }
        switch (barInput) {
            case HIGH: {
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.ASK, Double.valueOf(dataSeries.getAskHigh(n2)));
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.BID, Double.valueOf(dataSeries.getBidHigh(n2)));
                break;
            }
            case LOW: {
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.ASK, Double.valueOf(dataSeries.getAskLow(n2)));
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.BID, Double.valueOf(dataSeries.getBidLow(n2)));
                break;
            }
            case OPEN: {
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.ASK, Double.valueOf(dataSeries.getAskOpen(n2)));
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.BID, Double.valueOf(dataSeries.getBidOpen(n2)));
                break;
            }
            default: {
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.ASK, Double.valueOf(dataSeries.getAskClose(n2)));
                dataSeries.setDouble(n2, (Object)BidAskSpread$Values.BID, Double.valueOf(dataSeries.getBidClose(n2)));
            }
        }
        dataSeries.setComplete(n2);
    }
}

