/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.AccelerationBands$Signals;
import com.motivewave.platform.study.overlay.AccelerationBands$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ACCEL_BANDS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ACCEL_BANDS", menu="MENU_OVERLAY", desc="DESC_ACCEL_BANDS", label="LBL_ACCEL_BANDS", overlay=true, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/acceleration_bands.htm")
public class AccelerationBands
extends Study {
    static final String a = "accelFactor";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_ACCEL_FACTOR", new Object[0]), 0.001, 0.001, 10000.0, 0.001)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_BAND_LINES", new Object[0]), X11Colors.CADET_BLUE, 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("middleLine", this.get("LBL_MIDDLE_LINE", new Object[0]), X11Colors.DARK_SLATE_GRAY, 1.0f, new float[]{3.0f, 3.0f}, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup3);
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_CROSS_TOP_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingTab.addGroup(settingGroup4);
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_TOP_BOTTOM_IND", new Object[0]), X11Colors.CADET_BLUE, Color.WHITE, false, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor("middleInd", this.get("LBL_MIDDLE_IND", new Object[0]), X11Colors.DARK_SLATE_GRAY, Color.WHITE, false, false, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AccelerationBands$Values.TOP, this.get("LBL_ACCEL_TOP", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AccelerationBands$Values.MIDDLE, this.get("LBL_ACCEL_MID", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AccelerationBands$Values.BOTTOM, this.get("LBL_ACCEL_BOTTOM", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.declarePath((Object)AccelerationBands$Values.TOP, "line");
        runtimeDescriptor.declarePath((Object)AccelerationBands$Values.MIDDLE, "middleLine");
        runtimeDescriptor.declarePath((Object)AccelerationBands$Values.BOTTOM, "line");
        runtimeDescriptor.declareIndicator((Object)AccelerationBands$Values.TOP, "ind");
        runtimeDescriptor.declareIndicator((Object)AccelerationBands$Values.MIDDLE, "middleInd");
        runtimeDescriptor.declareIndicator((Object)AccelerationBands$Values.BOTTOM, "ind");
        runtimeDescriptor.declareSignal((Object)AccelerationBands$Signals.CROSS_ABOVE_TOP_BAND, this.get("LBL_CROSS_TOP_BAND", new Object[0]));
        runtimeDescriptor.declareSignal((Object)AccelerationBands$Signals.CROSS_BELOW_BOTTOM_BAND, this.get("LBL_CROSS_BOTTOM_BAND", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{AccelerationBands$Values.TOP, AccelerationBands$Values.BOTTOM});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        double d2 = this.getSettings().getDouble(a);
        Object object = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        double d5 = d3 * (1.0 + 2.0 * ((d3 - d4) / ((d3 + d4) / 2.0) * 1000.0 * d2));
        double d6 = d4 * (1.0 - 2.0 * ((d3 - d4) / ((d3 + d4) / 2.0) * 1000.0 * d2));
        dataSeries.setDouble(n2, (Object)AccelerationBands$Values.UB, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)AccelerationBands$Values.LB, Double.valueOf(d6));
        if (n2 < n3) {
            return;
        }
        Double d7 = dataSeries.sma(n2, n3, (Object)AccelerationBands$Values.UB);
        Double d8 = dataSeries.sma(n2, n3, (Object)AccelerationBands$Values.LB);
        Double d9 = dataSeries.sma(n2, n3, object);
        dataSeries.setDouble(n2, (Object)AccelerationBands$Values.TOP, d7);
        dataSeries.setDouble(n2, (Object)AccelerationBands$Values.MIDDLE, d9);
        dataSeries.setDouble(n2, (Object)AccelerationBands$Values.BOTTOM, d8);
        dataSeries.setComplete(n2);
        this.a(dataContext, n2);
        this.b(dataContext, n2);
    }

    private void a(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)AccelerationBands$Values.TOP);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedAbove(dataSeries, n2, Enums.BarInput.CLOSE, (Object)AccelerationBands$Values.TOP) && !dataSeries.getBoolean(n2, (Object)AccelerationBands$Signals.CROSS_ABOVE_TOP_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)AccelerationBands$Signals.CROSS_ABOVE_TOP_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("CROSS_ABOVE_TOP_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)AccelerationBands$Signals.CROSS_ABOVE_TOP_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }

    private void b(DataContext dataContext, int n2) {
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, (Object)AccelerationBands$Values.BOTTOM);
        if (d2 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d2.doubleValue());
        if (this.crossedBelow(dataSeries, n2, Enums.BarInput.CLOSE, (Object)AccelerationBands$Values.BOTTOM) && !dataSeries.getBoolean(n2, (Object)AccelerationBands$Signals.CROSS_BELOW_BOTTOM_BAND, false)) {
            dataSeries.setBoolean(n2, (Object)AccelerationBands$Signals.CROSS_BELOW_BOTTOM_BAND, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("CROSS_BELOW_BOTTOM_BAND", new Object[]{this.format(dataSeries.getClose(n2)), this.format(d2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)AccelerationBands$Signals.CROSS_BELOW_BOTTOM_BAND, string, (Object)this.round(dataSeries.getClose(n2)));
        }
    }
}

