/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.overlay;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.overlay.ATRChannel$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ATR_CHANNEL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ATR_CHANNEL", menu="MENU_OVERLAY", desc="DESC_ATR_CHANNEL", label="LBL_ATR_CHANNEL", overlay=true, helpLink="http://www.motivewave.com/studies/atr_channel.htm")
public class ATRChannel
extends Study {
    static final String a = "multiplier";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1), new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_MULTIPLIER", new Object[0]), 2.5, 0.1, 999.0, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("topLine", this.get("LBL_TOP_LINE", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("bottomLine", this.get("LBL_BOTTOM_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("fill", this.get("LBL_FILL_COLOR", new Object[0]), "topLine", "bottomLine", Enums.ShadeType.BOTH, defaults.getFillColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("topInd", this.get("LBL_TOP_IND", new Object[0]), defaults.getGreen(), Color.BLACK, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("bottomInd", this.get("LBL_BOTTOM_IND", new Object[0]), defaults.getRed(), Color.BLACK, false, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ATRChannel$Values.TOP, this.get("LBL_ATR_TOP", new Object[0]), new String[]{"period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ATRChannel$Values.BOTTOM, this.get("LBL_ATR_BOTTOM", new Object[0]), new String[]{"period", a}));
        runtimeDescriptor.declarePath((Object)ATRChannel$Values.TOP, "topLine");
        runtimeDescriptor.declarePath((Object)ATRChannel$Values.BOTTOM, "bottomLine");
        runtimeDescriptor.declareIndicator((Object)ATRChannel$Values.TOP, "topInd");
        runtimeDescriptor.declareIndicator((Object)ATRChannel$Values.BOTTOM, "bottomInd");
        runtimeDescriptor.setRangeKeys(new Object[]{ATRChannel$Values.TOP, ATRChannel$Values.BOTTOM});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onBarUpdate(DataContext dataContext) {
        if (!this.getSettings().isBarUpdates()) {
            return;
        }
        this.a(dataContext);
    }

    public void onBarClose(DataContext dataContext) {
        this.a(dataContext);
    }

    private void a(DataContext dataContext) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("shift", 0);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = dataSeries.size() - 1;
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        Double d3 = dataSeries.ma(mAMethod, n4, n2, (Object)Enums.BarInput.TR);
        if (d3 == null) {
            return;
        }
        double d4 = dataSeries.getClose(n4);
        double d5 = dataContext.getInstrument().round(d4 + d3 * d2);
        double d6 = dataContext.getInstrument().round(d4 - d3 * d2);
        dataSeries.setDouble(n4 + n3, (Object)ATRChannel$Values.TOP, Double.valueOf(d5));
        dataSeries.setDouble(n4 + n3, (Object)ATRChannel$Values.BOTTOM, Double.valueOf(d6));
    }

    protected void calculateValues(DataContext dataContext) {
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("shift", 0);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = dataSeries.size() - 1;
        boolean bl2 = this.getSettings().isBarUpdates();
        for (int i2 = n2; i2 < dataSeries.size(); ++i2) {
            Double d3;
            if (dataSeries.isComplete(i2 + n3) || !bl2 && !dataSeries.isBarComplete(i2) || (d3 = dataSeries.ma(mAMethod, i2, n2, (Object)Enums.BarInput.TR)) == null) continue;
            double d4 = dataSeries.getClose(i2);
            double d5 = dataContext.getInstrument().round(d4 + d3 * d2);
            double d6 = dataContext.getInstrument().round(d4 - d3 * d2);
            dataSeries.setDouble(i2 + n3, (Object)ATRChannel$Values.TOP, Double.valueOf(d5));
            dataSeries.setDouble(i2 + n3, (Object)ATRChannel$Values.BOTTOM, Double.valueOf(d6));
            dataSeries.setComplete(i2 + n3, i2 >= 0 && i2 < n4);
        }
    }
}

