/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.ma;

import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.ma.MACross;
import com.motivewave.platform.study.ma.MACross$Signals;
import com.motivewave.platform.study.ma.MACross$Values;

@StudyHeader(namespace="com.motivewave", id="MA_CROSS_STRATEGY", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MA_CROSS_STRATEGY", desc="DESC_MA_CROSS_STRATEGY", menu="MENU_GENERAL", overlay=true, signals=true, strategy=true, autoEntry=true, manualEntry=false, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsPositionType=true, helpLink="http://www.motivewave.com/strategies/ma_cross_strategy.htm")
public class d
extends MACross {
    public void onActivate(OrderContext orderContext) {
        if (this.getSettings().isEnterOnActivate()) {
            DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
            int n2 = dataSeries.isLastBarComplete() ? dataSeries.size() - 1 : dataSeries.size() - 2;
            Double d2 = dataSeries.getDouble(n2, (Object)MACross$Values.FAST_MA);
            Double d3 = dataSeries.getDouble(n2, (Object)MACross$Values.SLOW_MA);
            if (d2 == null || d3 == null) {
                return;
            }
            int n3 = this.getSettings().getTradeLots();
            n3 = (int)((float)n3 * orderContext.getInstrument().getDefaultQuantityAsFloat());
            float f2 = n3;
            switch (this.getSettings().getPositionType()) {
                case LONG: {
                    if (!(d2 > d3)) break;
                    orderContext.buy(f2);
                    break;
                }
                case SHORT: {
                    if (!(d2 < d3)) break;
                    orderContext.sell(f2);
                    break;
                }
                default: {
                    if (d2 > d3) {
                        orderContext.buy(f2);
                        break;
                    }
                    orderContext.sell(f2);
                }
            }
        }
    }

    public void onSignal(OrderContext orderContext, Object object) {
        Instrument instrument = orderContext.getInstrument();
        float f2 = orderContext.getPositionAsFloat();
        float f3 = (float)this.getSettings().getTradeLots() * instrument.getDefaultQuantityAsFloat();
        switch (this.getSettings().getPositionType()) {
            case LONG: {
                if (f2 == 0.0f && object == MACross$Signals.CROSS_ABOVE) {
                    orderContext.buy(f3);
                }
                if (!(f2 > 0.0f) || object != MACross$Signals.CROSS_BELOW) break;
                orderContext.sell(f3);
                break;
            }
            case SHORT: {
                if (f2 == 0.0f && object == MACross$Signals.CROSS_BELOW) {
                    orderContext.sell(f3);
                }
                if (!(f2 < 0.0f) || object != MACross$Signals.CROSS_ABOVE) break;
                orderContext.buy(f3);
                break;
            }
            default: {
                f3 += Math.abs(f2);
                if (f2 <= 0.0f && object == MACross$Signals.CROSS_ABOVE) {
                    orderContext.buy(f3);
                }
                if (!(f2 >= 0.0f) || object != MACross$Signals.CROSS_BELOW) break;
                orderContext.sell(f3);
            }
        }
    }
}

