/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.ma;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.ma.VWAP$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="VWAP", rb="com.motivewave.platform.study.nls.strings", name="TITLE_VWAP", desc="DESC_VWAP", label="LBL_VWAP", menu="MENU_MOVING_AVERAGE", menu2="MENU_VOLUME", overlay=true, signals=true, requiresVolume=true, studyOverlay=true, helpLink="http://www.motivewave.com/studies/volume_weighted_average_price.htm")
public class VWAP
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.TP)});
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor("barSize", this.get("LBL_TIMEFRAME", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)1440))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), defaults.getBlue(), Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "barSize"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VWAP$Values.VWAP, this.get("LBL_VWAP", new Object[0]), new String[]{"input", "barSize"}));
        runtimeDescriptor.declarePath((Object)VWAP$Values.VWAP, "line");
        runtimeDescriptor.declareIndicator((Object)VWAP$Values.VWAP, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VWAP$Values.VWAP});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculateValues(DataContext dataContext) {
        int n2;
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = this.getSettings().getBarSize("barSize");
        DataSeries dataSeries2 = dataContext.getDataSeries(barSize);
        Object object = this.getSettings().getInput("input");
        if (dataSeries2.size() < 2) {
            return;
        }
        if (dataSeries.getBarSize().getIntervalMinutes() >= dataSeries2.getBarSize().getIntervalMinutes()) {
            return;
        }
        int n3 = -1;
        int n4 = -1;
        boolean bl2 = this.getSettings().isBarUpdates();
        for (n2 = 1; n2 < dataSeries.size(); ++n2) {
            if (!bl2 && !dataSeries.isBarComplete(n2)) continue;
            long l2 = dataSeries.getStartTime(n2);
            long l3 = dataSeries.getStartTime(n2 - 1);
            for (int i2 = 0; i2 < dataSeries2.size(); ++i2) {
                long l4 = dataSeries2.getStartTime(i2);
                long l5 = dataSeries2.getEndTime(i2);
                if (l4 > l2 || l2 >= l5 || l3 >= l4) continue;
                n4 = i2;
                n3 = n2;
                break;
            }
            if (n4 >= 0) break;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        n2 = n3;
        for (int i3 = n3; i3 < dataSeries.size(); ++i3) {
            if (!bl2 && !dataSeries.isBarComplete(i3)) continue;
            if (dataSeries.getStartTime(i3) >= dataSeries2.getEndTime(n4)) {
                n2 = i3;
                if (++n4 >= dataSeries2.size()) break;
                dataSeries.setDouble(i3, (Object)VWAP$Values.VWAP, dataSeries.getDouble(i3, object));
                dataSeries.setComplete(i3, dataSeries.isBarComplete(i3));
                continue;
            }
            if (dataSeries.isComplete(i3)) continue;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i4 = n2; i4 <= i3; ++i4) {
                Double d4 = dataSeries.getDouble(i4, object);
                if (d4 == null || Double.isNaN(d4)) continue;
                d3 += d4 * (double)dataSeries.getVolume(i4);
                d2 += (double)dataSeries.getVolume(i4);
            }
            if (d2 == 0.0) {
                return;
            }
            dataSeries.setDouble(i3, (Object)VWAP$Values.VWAP, Double.valueOf(d3 / d2));
            dataSeries.setComplete(i3, dataSeries.isBarComplete(i3));
        }
    }
}

