/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.ma;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.ma.MACross$Signals;
import com.motivewave.platform.study.ma.MACross$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="MA_CROSS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MA_CROSS", label="LBL_MA_CROSS", desc="DESC_MA_CROSS", menu="MENU_MOVING_AVERAGE", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/moving_average_cross.htm")
public class MACross
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.a(settingTab);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_FAST_MA", new Object[0]), defaults.getGreenLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_SLOW_MA", new Object[0]), defaults.getBlueLine(), 1.0f, null, true, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "line", "line2", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "line", "line2", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), false, true)});
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_FAST_MA", new Object[0]), defaults.getGreenLine(), Color.WHITE, false, false, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LBL_SLOW_MA", new Object[0]), defaults.getBlueLine(), Color.WHITE, false, false, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "input2", "method2", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACross$Values.FAST_MA, this.get("LBL_FAST_MA", new Object[0]), new String[]{"input", "method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACross$Values.SLOW_MA, this.get("LBL_SLOW_MA", new Object[0]), new String[]{"input2", "method2", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACross$Signals.CROSS_ABOVE, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_ABOVE", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACross$Signals.CROSS_BELOW, Enums.ValueType.BOOLEAN, this.get("LBL_CROSS_BELOW", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)MACross$Values.FAST_MA, "line");
        runtimeDescriptor.declarePath((Object)MACross$Values.SLOW_MA, "line2");
        runtimeDescriptor.declareIndicator((Object)MACross$Values.FAST_MA, "ind");
        runtimeDescriptor.declareIndicator((Object)MACross$Values.SLOW_MA, "ind2");
        runtimeDescriptor.declareSignal((Object)MACross$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MACross$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{MACross$Values.FAST_MA, MACross$Values.SLOW_MA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3) * 2);
    }

    protected void a(SettingTab settingTab) {
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_FAST_MA", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_FAST_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_FAST_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_FAST_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_SLOW_MA", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("LBL_SLOW_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup2.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("LBL_SLOW_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup2.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_SLOW_PERIOD", new Object[0]), 20, 1, 9999, 1)});
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        if (n2 < Math.max(n4, n3 = this.getSettings().getInteger("period2").intValue())) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(this.getSettings().getMAMethod("method"), n2, n4, this.getSettings().getInput("input"));
        Double d3 = dataSeries.ma(this.getSettings().getMAMethod("method2"), n2, n3, this.getSettings().getInput("input2"));
        if (d2 == null || d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MACross$Values.FAST_MA, d2);
        dataSeries.setDouble(n2, (Object)MACross$Values.SLOW_MA, d3);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d3.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)MACross$Values.FAST_MA, (Object)MACross$Values.SLOW_MA)) {
            dataSeries.setBoolean(n2, (Object)MACross$Signals.CROSS_ABOVE, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_CROSS_ABOVE", new Object[]{this.format(d2), this.format(d3), this.format(dataSeries.getClose(n2))});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MACross$Signals.CROSS_ABOVE, string, (Object)this.round(d2));
        } else if (this.crossedBelow(dataSeries, n2, (Object)MACross$Values.FAST_MA, (Object)MACross$Values.SLOW_MA)) {
            dataSeries.setBoolean(n2, (Object)MACross$Signals.CROSS_BELOW, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_CROSS_BELOW", new Object[]{this.format(d2), this.format(d3), this.format(dataSeries.getClose(n2))});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MACross$Signals.CROSS_BELOW, string, (Object)this.round(d2));
        }
        dataSeries.setComplete(n2);
    }
}

