/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.ma;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.study.ma.MABase$Signals;
import com.motivewave.platform.study.ma.MABase$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MABase
extends Study {
    protected String a;
    protected Enums.MAMethod a = "";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1), new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor("fillForward", this.get("LBL_FILL_FORWARD", new Object[0]), Boolean.valueOf(true))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), null, 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_BAR_COLOR", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new BooleanDescriptor("enableBarColor", this.get("LBL_ENABLE_BAR_COLOR", new Object[0]), Boolean.valueOf(false))});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreenLine())});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getLineColor())});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRedLine())});
        settingTab.addGroup(settingGroup3);
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency("enableBarColor", new String[]{"upColor", "neutralColor", "downColor"}));
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup4);
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "shift"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MABase$Values.MA, this.a, new String[]{"input", "period", "shift"}));
        runtimeDescriptor.declarePath((Object)MABase$Values.MA, "line");
        runtimeDescriptor.declareIndicator((Object)MABase$Values.MA, "ind");
        runtimeDescriptor.declareSignal((Object)MABase$Signals.CROSS_ABOVE, this.get("LBL_PRICE_CROSS_ABOVE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MABase$Signals.CROSS_BELOW, this.get("LBL_PRICE_CROSS_BELOW", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public int getMinBars() {
        int n2 = this.getSettings().getInteger("shift");
        int n3 = this.getSettings().getInteger("period") + (n2 > 0 ? n2 : 0);
        Enums.MAMethod mAMethod = this.a;
        if (Util.in((Object)mAMethod, (Object[])new Object[]{Enums.MAMethod.EMA, Enums.MAMethod.SMMA, Enums.MAMethod.DEMA, Enums.MAMethod.KAMA, Enums.MAMethod.MEMA})) {
            n3 *= 2;
        }
        return n3;
    }

    public void onBarUpdate(DataContext dataContext) {
        if (!this.getSettings().isBarUpdates()) {
            return;
        }
        this.a(dataContext);
    }

    public void onBarClose(DataContext dataContext) {
        this.a(dataContext);
    }

    protected void a(DataContext dataContext) {
        String string;
        boolean bl2;
        Settings settings = this.getSettings();
        if (settings == null) {
            return;
        }
        Util.calcLatestMA((DataContext)dataContext, (Enums.MAMethod)this.a, (Object)settings.getInput("input"), (int)settings.getInteger("period"), (int)settings.getInteger("shift", 0), (Object)((Object)MABase$Values.MA), (boolean)settings.getBoolean("fillForward", true));
        MarkerInfo markerInfo = settings.getMarker("upMarker");
        MarkerInfo markerInfo2 = settings.getMarker("downMarker");
        boolean bl3 = settings.getBoolean("enableBarColor", false);
        boolean bl4 = markerInfo != null && markerInfo.isEnabled();
        boolean bl5 = bl2 = markerInfo2 != null && markerInfo2.isEnabled();
        if (!(bl3 || bl4 || bl2 || dataContext.isSignalEnabled((Object)MABase$Signals.CROSS_ABOVE) || dataContext.isSignalEnabled((Object)MABase$Signals.CROSS_BELOW))) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble((Object)MABase$Values.MA);
        Double d3 = dataSeries.getDouble(dataSeries.size() - 2, (Object)MABase$Values.MA);
        if (d2 == null || d3 == null) {
            return;
        }
        if (bl3) {
            if (d2 < d3) {
                dataSeries.setPriceBarColor(settings.getColor("downColor"));
            } else if (d2 == d3) {
                dataSeries.setPriceBarColor(settings.getColor("neutralColor"));
            } else {
                dataSeries.setPriceBarColor(settings.getColor("upColor"));
            }
        }
        if (dataSeries.size() <= 1) {
            return;
        }
        double d4 = d2;
        double d5 = d3;
        float f2 = dataSeries.getInstrument().round((float)d4);
        float f3 = dataSeries.getInstrument().round((float)d5);
        float f4 = dataSeries.getClose();
        float f5 = dataSeries.getClose(dataSeries.size() - 2);
        int n2 = dataSeries.size() - 1;
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)f2);
        if ((bl4 || dataContext.isSignalEnabled((Object)MABase$Signals.CROSS_ABOVE)) && f5 <= f3 && f4 > f2) {
            string = this.get("SIGNAL_PRICE_CROSS_ABOVE", new Object[]{this.format(f4), this.format(f2)});
            if (bl4 && !dataSeries.getBoolean((Object)"UP_MARKER_ADDED", false)) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
                dataSeries.setBoolean((Object)"UP_MARKER_ADDED", Boolean.valueOf(true));
            }
            dataContext.signal(n2, (Object)MABase$Signals.CROSS_ABOVE, string, (Object)this.round(f4));
        }
        if ((bl2 || dataContext.isSignalEnabled((Object)MABase$Signals.CROSS_BELOW)) && f5 >= f3 && f4 < f2) {
            string = this.get("SIGNAL_PRICE_CROSS_BELOW", new Object[]{this.format(f4), this.format(f2)});
            if (bl2 && !dataSeries.getBoolean((Object)"DOWN_MARKER_ADDED", false)) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo2, string));
                dataSeries.setBoolean((Object)"DOWN_MARKER_ADDED", Boolean.valueOf(true));
            }
            dataContext.signal(n2, (Object)MABase$Signals.CROSS_BELOW, string, (Object)this.round(f4));
        }
    }

    protected void calculateValues(DataContext dataContext) {
        boolean bl2;
        Settings settings = this.getSettings();
        if (settings == null) {
            return;
        }
        Util.calcSeriesMA((DataContext)dataContext, (Enums.MAMethod)this.a, (Object)settings.getInput("input"), (int)settings.getInteger("period"), (int)settings.getInteger("shift", 0), (Object)((Object)MABase$Values.MA), (boolean)settings.getBoolean("fillForward", true), (boolean)settings.isBarUpdates());
        MarkerInfo markerInfo = settings.getMarker("upMarker");
        MarkerInfo markerInfo2 = settings.getMarker("downMarker");
        boolean bl3 = settings.getBoolean("enableBarColor", false);
        boolean bl4 = markerInfo != null && markerInfo.isEnabled();
        boolean bl5 = bl2 = markerInfo2 != null && markerInfo2.isEnabled();
        if (!(bl3 || bl4 || bl2 || dataContext.isSignalEnabled((Object)MABase$Signals.CROSS_ABOVE) || dataContext.isSignalEnabled((Object)MABase$Signals.CROSS_BELOW))) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries == null) {
            return;
        }
        this.clearFigures();
        boolean bl6 = settings.isBarUpdates();
        for (int i2 = 1; i2 < dataSeries.size(); ++i2) {
            String string;
            Double d2;
            Double d3;
            if (!bl6 && !dataSeries.isBarComplete(i2) || (d3 = dataSeries.getDouble(i2, (Object)MABase$Values.MA)) == null) continue;
            if (bl3) {
                d2 = dataSeries.getDouble(i2 - 1, (Object)MABase$Values.MA);
                if (d2 == null) continue;
                if (d3 < d2) {
                    dataSeries.setPriceBarColor(i2, settings.getColor("downColor"));
                } else if (d3 == d2) {
                    dataSeries.setPriceBarColor(i2, settings.getColor("neutralColor"));
                } else {
                    dataSeries.setPriceBarColor(i2, settings.getColor("upColor"));
                }
            }
            d2 = new Coordinate(dataSeries.getStartTime(i2), d3.doubleValue());
            float f2 = dataSeries.getClose(i2);
            if (this.crossedAbove(dataSeries, i2, Enums.BarInput.CLOSE, (Object)MABase$Values.MA)) {
                dataSeries.setBoolean(i2, (Object)MABase$Signals.CROSS_ABOVE, Boolean.valueOf(true));
                string = this.get("SIGNAL_PRICE_CROSS_ABOVE", new Object[]{this.format(f2), this.format(d3)});
                if (bl4) {
                    this.addFigure((Figure)new Marker((Coordinate)d2, Enums.Position.BOTTOM, markerInfo, string));
                }
                dataContext.signal(i2, (Object)MABase$Signals.CROSS_ABOVE, string, (Object)this.round(f2));
                continue;
            }
            if (!this.crossedBelow(dataSeries, i2, Enums.BarInput.CLOSE, (Object)MABase$Values.MA)) continue;
            dataSeries.setBoolean(i2, (Object)MABase$Signals.CROSS_BELOW, Boolean.valueOf(true));
            string = this.get("SIGNAL_PRICE_CROSS_BELOW", new Object[]{this.format(f2), this.format(d3)});
            if (bl2) {
                this.addFigure((Figure)new Marker((Coordinate)d2, Enums.Position.TOP, markerInfo2, string));
            }
            dataContext.signal(i2, (Object)MABase$Signals.CROSS_BELOW, string, (Object)this.round(f2));
        }
    }
}

