/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.ma;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.ma.HullMA$Signals;
import com.motivewave.platform.study.ma.HullMA$Values;

@StudyHeader(namespace="com.motivewave", id="HMA", rb="com.motivewave.platform.study.nls.strings", name="TITLE_HMA", desc="DESC_HMA", label="LBL_HMA", menu="MENU_MOVING_AVERAGE", overlay=true, signals=true, studyOverlay=true, helpLink="http://www.motivewave.com/studies/hull_moving_average.htm")
public class HullMA
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.WMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1), new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), null, 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_BAR_COLOR", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new BooleanDescriptor("enableBarColor", this.get("LBL_ENABLE_BAR_COLOR", new Object[0]), Boolean.valueOf(false))});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreenLine())});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getLineColor())});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRedLine())});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup4);
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency("enableBarColor", new String[]{"upColor", "neutralColor", "downColor"}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "shift"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HullMA$Values.MA, this.get("LBL_HMA", new Object[0]), new String[]{"input", "method", "period", "shift"}));
        runtimeDescriptor.declarePath((Object)HullMA$Values.MA, "line");
        runtimeDescriptor.declareIndicator((Object)HullMA$Values.MA, "ind");
        runtimeDescriptor.declareSignal((Object)HullMA$Signals.CROSS_ABOVE, this.get("LBL_PRICE_CROSS_ABOVE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)HullMA$Signals.CROSS_BELOW, this.get("LBL_PRICE_CROSS_BELOW", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onBarUpdate(DataContext dataContext) {
        String string;
        boolean bl2;
        Object object = this.getSettings().getInput("input");
        int n2 = this.getSettings().getInteger("shift");
        int n3 = this.getSettings().getInteger("period");
        int n4 = (int)Math.sqrt(n3);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n5 = dataSeries.size() - 1;
        if (dataSeries.size() <= 1) {
            return;
        }
        Double d2 = dataSeries.ma(mAMethod, n5, n3 / 2, object);
        if (d2 == null) {
            return;
        }
        d2 = 2.0 * d2;
        Double d3 = dataSeries.ma(mAMethod, n5, n3, object);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n5, (Object)"MA_TMP", Double.valueOf(d2 - d3));
        Double d4 = null;
        d4 = n2 >= 0 ? dataSeries.ma(mAMethod, n5, n4, (Object)"MA_TMP") : dataSeries.ma(mAMethod, n5 - n2, n4, (Object)"MA_TMP");
        if (d4 == null) {
            return;
        }
        if (n2 >= 0) {
            dataSeries.setDouble(n5 + n2, (Object)HullMA$Values.MA, d4);
        } else {
            dataSeries.setDouble(n5, (Object)HullMA$Values.MA, d4);
        }
        MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
        MarkerInfo markerInfo2 = this.getSettings().getMarker("downMarker");
        boolean bl3 = this.getSettings().getBoolean("enableBarColor", false);
        boolean bl4 = markerInfo != null && markerInfo.isEnabled();
        boolean bl5 = bl2 = markerInfo2 != null && markerInfo2.isEnabled();
        if (!(bl3 || bl4 || bl2 || dataContext.isSignalEnabled((Object)HullMA$Signals.CROSS_ABOVE) || dataContext.isSignalEnabled((Object)HullMA$Signals.CROSS_BELOW))) {
            return;
        }
        Double d5 = dataSeries.getDouble((Object)HullMA$Values.MA);
        Double d6 = dataSeries.getDouble(dataSeries.size() - 2, (Object)HullMA$Values.MA);
        if (d5 == null || d6 == null) {
            return;
        }
        if (bl3) {
            if (d5 < d6) {
                dataSeries.setPriceBarColor(this.getSettings().getColor("downColor"));
            } else if (d5 == d6) {
                dataSeries.setPriceBarColor(this.getSettings().getColor("neutralColor"));
            } else {
                dataSeries.setPriceBarColor(this.getSettings().getColor("upColor"));
            }
        }
        double d7 = d5;
        double d8 = d6;
        float f2 = dataSeries.getInstrument().round((float)d7);
        float f3 = dataSeries.getInstrument().round((float)d8);
        float f4 = dataSeries.getClose();
        float f5 = dataSeries.getClose(dataSeries.size() - 2);
        int n6 = dataSeries.size() - 1;
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n6), (double)f2);
        if ((bl4 || dataContext.isSignalEnabled((Object)HullMA$Signals.CROSS_ABOVE)) && f5 <= f3 && f4 > f2) {
            string = this.get("SIGNAL_PRICE_CROSS_ABOVE", new Object[]{this.format(f4), this.format(f2)});
            if (bl4 && !dataSeries.getBoolean((Object)"UP_MARKER_ADDED", false)) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
                dataSeries.setBoolean((Object)"UP_MARKER_ADDED", Boolean.valueOf(true));
            }
            dataContext.signal(n6, (Object)HullMA$Signals.CROSS_ABOVE, string, (Object)this.round(f4));
        }
        if ((bl2 || dataContext.isSignalEnabled((Object)HullMA$Signals.CROSS_BELOW)) && f5 >= f3 && f4 < f2) {
            string = this.get("SIGNAL_PRICE_CROSS_BELOW", new Object[]{this.format(f4), this.format(f2)});
            if (bl2 && !dataSeries.getBoolean((Object)"DOWN_MARKER_ADDED", false)) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo2, string));
                dataSeries.setBoolean((Object)"DOWN_MARKER_ADDED", Boolean.valueOf(true));
            }
            dataContext.signal(n6, (Object)HullMA$Signals.CROSS_BELOW, string, (Object)this.round(f4));
        }
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(this.getSettings().getInteger("period"));
    }

    protected synchronized void calculateValues(DataContext dataContext) {
        boolean bl2;
        Object object;
        int n2;
        int n3 = this.getSettings().getInteger("period");
        int n4 = (int)Math.sqrt(n3);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        int n5 = this.getSettings().getInteger("shift");
        Object object2 = this.getSettings().getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        for (n2 = n3; n2 < dataSeries.size(); ++n2) {
            Double d2;
            if (dataSeries.isComplete(n2) || (d2 = dataSeries.ma(mAMethod, n2, n3 / 2, object2)) == null) continue;
            d2 = d2 * 2.0;
            Double d3 = dataSeries.ma(mAMethod, n2, n3, object2);
            if (d3 == null) continue;
            dataSeries.setDouble(n2, (Object)"MA_TMP", Double.valueOf(d2 - d3));
        }
        n2 = dataSeries.size() - 1;
        int n6 = 0;
        if (n6 <= n3 + n4) {
            n6 = n3 + n4;
        }
        int n7 = dataSeries.size() - 1;
        if (n5 < 0) {
            n7 += n5;
        }
        for (int i2 = n6; i2 <= n2; ++i2) {
            if (dataSeries.isComplete(i2 + n5) || (object = dataSeries.ma(mAMethod, i2, n4, (Object)"MA_TMP")) == null) continue;
            dataSeries.setDouble(i2 + n5, (Object)HullMA$Values.MA, (Double)object);
            dataSeries.setComplete(i2 + n5, i2 >= 0 && i2 < n7);
        }
        MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
        object = this.getSettings().getMarker("downMarker");
        boolean bl3 = this.getSettings().getBoolean("enableBarColor", false);
        boolean bl4 = markerInfo != null && markerInfo.isEnabled();
        boolean bl5 = bl2 = object != null && object.isEnabled();
        if (!(bl3 || bl4 || bl2 || dataContext.isSignalEnabled((Object)HullMA$Signals.CROSS_ABOVE) || dataContext.isSignalEnabled((Object)HullMA$Signals.CROSS_BELOW))) {
            return;
        }
        this.clearFigures();
        for (int i3 = 1; i3 < dataSeries.size(); ++i3) {
            String string;
            Double d4;
            Double d5 = dataSeries.getDouble(i3, (Object)HullMA$Values.MA);
            if (d5 == null) continue;
            if (bl3) {
                d4 = dataSeries.getDouble(i3 - 1, (Object)HullMA$Values.MA);
                if (d4 == null) continue;
                if (d5 < d4) {
                    dataSeries.setPriceBarColor(i3, this.getSettings().getColor("downColor"));
                } else if (d5 == d4) {
                    dataSeries.setPriceBarColor(i3, this.getSettings().getColor("neutralColor"));
                } else {
                    dataSeries.setPriceBarColor(i3, this.getSettings().getColor("upColor"));
                }
            }
            d4 = new Coordinate(dataSeries.getStartTime(i3), d5.doubleValue());
            float f2 = dataSeries.getClose(i3);
            if (this.crossedAbove(dataSeries, i3, Enums.BarInput.CLOSE, (Object)HullMA$Values.MA)) {
                dataSeries.setBoolean(i3, (Object)HullMA$Signals.CROSS_ABOVE, Boolean.valueOf(true));
                string = this.get("SIGNAL_PRICE_CROSS_ABOVE", new Object[]{this.format(f2), this.format(d5)});
                if (bl4) {
                    this.addFigure((Figure)new Marker((Coordinate)d4, Enums.Position.BOTTOM, markerInfo, string));
                }
                dataContext.signal(i3, (Object)HullMA$Signals.CROSS_ABOVE, string, (Object)this.round(f2));
                continue;
            }
            if (!this.crossedBelow(dataSeries, i3, Enums.BarInput.CLOSE, (Object)HullMA$Values.MA)) continue;
            dataSeries.setBoolean(i3, (Object)HullMA$Signals.CROSS_BELOW, Boolean.valueOf(true));
            string = this.get("SIGNAL_PRICE_CROSS_BELOW", new Object[]{this.format(f2), this.format(d5)});
            if (bl2) {
                this.addFigure((Figure)new Marker((Coordinate)d4, Enums.Position.TOP, object, string));
            }
            dataContext.signal(i3, (Object)HullMA$Signals.CROSS_BELOW, string, (Object)this.round(f2));
        }
    }
}

