/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.instrument;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.PriceData;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.PriceBarDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.instrument.Spread$Values;
import java.util.ArrayList;

@StudyHeader(namespace="com.motivewave", id="SPREAD", rb="com.motivewave.platform.study.nls.strings", name="TITLE_SPREAD", desc="DESC_SPREAD", menu="MENU_INSTRUMENT", overlay=false, multipleInstrument=true, requiresBarUpdates=true)
public class Spread
extends Study {
    static final String a = "multiplier1";
    static final String b = "multiplier2";
    static final String c = "operation";
    static final String d = "invert";
    static final String e = "SUBTRACT";
    static final String f = "DIVIDE";
    static final String g = "ADD";
    static final String h = "MULTIPLY";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument1", this.get("LBL_INSTRUMENT1", new Object[0]), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_MULTIPLIER", new Object[0]), 1.0, 0.01, 10000.0, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument2", this.get("LBL_INSTRUMENT2", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("LBL_MULTIPLIER", new Object[0]), 1.0, 0.01, 10000.0, 0.01)});
        ArrayList<NVP> arrayList = new ArrayList<NVP>();
        arrayList.add(new NVP(this.get("LBL_SUBTRACT", new Object[0]), e));
        arrayList.add(new NVP(this.get("LBL_DIVIDE", new Object[0]), f));
        arrayList.add(new NVP(this.get("LBL_ADD", new Object[0]), g));
        arrayList.add(new NVP(this.get("LBL_MULTIPLY", new Object[0]), h));
        settingGroup.addRow(new SettingDescriptor[]{new DiscreteDescriptor(c, this.get("LBL_OPERATION", new Object[0]), e, arrayList)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(d, this.get("LBL_INVERT", new Object[0]), Boolean.valueOf(false))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new PriceBarDescriptor("priceBar", this.get("LBL_PRICE_BAR", new Object[0]), null, Enums.BarInput.CLOSE, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Spread$Values.CLOSE, this.get("LBL_SPREAD", new Object[0]), new String[]{"instrument1", "instrument2"}));
        runtimeDescriptor.setLabelSettings(new String[]{"instrument1", "instrument2", c});
        runtimeDescriptor.declarePriceBar((Object)Spread$Values.PRICE_BAR, "priceBar");
        runtimeDescriptor.declareIndicator((Object)Spread$Values.CLOSE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{Spread$Values.HIGH, Spread$Values.LOW});
        runtimeDescriptor.getDefaultPlot().setFormatMK(false);
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries;
        Instrument instrument = this.getSettings().getInstrument("instrument1");
        Instrument instrument2 = this.getSettings().getInstrument("instrument2");
        float f2 = (float)this.getSettings().getDouble(a, 1.0);
        float f3 = (float)this.getSettings().getDouble(b, 1.0);
        String string = this.getSettings().getString(c, e);
        boolean bl2 = this.getSettings().getBoolean(d, false);
        if (f2 == 0.0f) {
            f2 = 1.0f;
        }
        if (f3 == 0.0f) {
            f3 = 1.0f;
        }
        if ((dataSeries = dataContext.getDataSeries()) == null) {
            return;
        }
        float f4 = dataSeries.getOpen(n2, instrument);
        if (f4 == 0.0f) {
            return;
        }
        float f5 = dataSeries.getOpen(n2, instrument2);
        if (f5 == 0.0f) {
            return;
        }
        float f6 = dataSeries.getHigh(n2, instrument);
        if (f6 == 0.0f) {
            return;
        }
        float f7 = dataSeries.getHigh(n2, instrument2);
        if (f7 == 0.0f) {
            return;
        }
        float f8 = dataSeries.getLow(n2, instrument);
        if (f8 == 0.0f) {
            return;
        }
        float f9 = dataSeries.getLow(n2, instrument2);
        if (f9 == 0.0f) {
            return;
        }
        float f10 = dataSeries.getClose(n2, instrument);
        if (f10 == 0.0f) {
            return;
        }
        float f11 = dataSeries.getClose(n2, instrument2);
        if (f11 == 0.0f) {
            return;
        }
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        if (Util.compare((Object)string, (Object)e)) {
            f12 = f4 * f2 - f5 * f3;
            f13 = f6 * f2 - f7 * f3;
            f14 = f8 * f2 - f9 * f3;
            f15 = f10 * f2 - f11 * f3;
        } else if (Util.compare((Object)string, (Object)f)) {
            f12 = f4 * f2 / f5 * f3;
            f13 = f6 * f2 / f7 * f3;
            f14 = f8 * f2 / f9 * f3;
            f15 = f10 * f2 / f11 * f3;
        }
        if (Util.compare((Object)string, (Object)g)) {
            f12 = f4 * f2 + f5 * f3;
            f13 = f6 * f2 + f7 * f3;
            f14 = f8 * f2 + f9 * f3;
            f15 = f10 * f2 + f11 * f3;
        }
        if (Util.compare((Object)string, (Object)h)) {
            f12 = f4 * f2 * f5 * f3;
            f13 = f6 * f2 * f7 * f3;
            f14 = f8 * f2 * f9 * f3;
            f15 = f10 * f2 * f11 * f3;
        }
        if (bl2) {
            f12 = 1.0f / f12;
            f15 = 1.0f / f15;
            f13 = 1.0f / f13;
            f14 = 1.0f / f14;
        }
        float f16 = Util.maxFloat((float[])new float[]{f12, f13, f14, f15});
        float f17 = Util.minFloat((float[])new float[]{f12, f13, f14, f15});
        dataSeries.setFloat(n2, (Object)Spread$Values.OPEN, Float.valueOf(f12));
        dataSeries.setFloat(n2, (Object)Spread$Values.CLOSE, Float.valueOf(f15));
        dataSeries.setFloat(n2, (Object)Spread$Values.HIGH, Float.valueOf(f16));
        dataSeries.setFloat(n2, (Object)Spread$Values.LOW, Float.valueOf(f17));
        dataSeries.setValue(n2, (Object)Spread$Values.PRICE_BAR, (Object)new PriceData(f12, f16, f17, f15));
    }

    public void onBarUpdate(DataContext dataContext) {
        Instrument instrument = this.getSettings().getInstrument("instrument1");
        DataSeries dataSeries = dataContext.getDataSeries();
        int n2 = dataSeries.size();
        float f2 = 0.0f;
        do {
            f2 = dataSeries.getClose(--n2, instrument);
        } while (n2 > 0 && f2 == 0.0f);
        instrument = this.getSettings().getInstrument("instrument2");
        int n3 = dataSeries.size();
        f2 = 0.0f;
        do {
            f2 = dataSeries.getClose(--n3, instrument);
        } while (n2 > 0 && f2 == 0.0f);
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        this.calculate(Util.minInt((int[])new int[]{n2, n3}), dataContext);
    }
}

