/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.instrument;

import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.PriceBarInfo;
import com.motivewave.platform.sdk.common.PriceData;
import com.motivewave.platform.sdk.common.TickOperation;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.PriceBarDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.instrument.InstrumentGraph$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="INSTRUMENT_GRAPH", rb="com.motivewave.platform.study.nls.strings", name="TITLE_INSTRUMENT_GRAPH", desc="DESC_INSTRUMENT_GRAPH", menu="MENU_INSTRUMENT", overlay=false, multipleInstrument=true, supportsBarUpdates=false)
public class InstrumentGraph
extends Study {
    private DataContext a;
    private TickOperation a = tick -> {
        if (this.getSettings() == null) {
            return;
        }
        Instrument instrument = this.getSettings().getInstrument("instrument");
        if (this.a == null || instrument == null) {
            return;
        }
        DataSeries dataSeries = this.a.getDataSeries();
        if (dataSeries == null) {
            return;
        }
        int n2 = dataSeries.size() - 1;
        PriceData priceData = (PriceData)dataSeries.getValue(n2, (Object)InstrumentGraph$Values.PRICE_BAR);
        if (priceData == null) {
            for (int i2 = n2; i2 > dataSeries.size() - 60 && i2 >= 0; --i2) {
                priceData = (PriceData)dataSeries.getValue(n2, (Object)InstrumentGraph$Values.PRICE_BAR);
                if (priceData == null) continue;
                n2 = i2;
                break;
            }
            if (priceData == null) {
                return;
            }
        }
        float f2 = priceData.getHigh();
        float f3 = priceData.getLow();
        float f4 = tick.getPrice();
        boolean bl2 = false;
        if (f4 > f2) {
            f2 = f4;
            bl2 = true;
        }
        if (f4 < f3) {
            f3 = f4;
            bl2 = true;
        }
        dataSeries.setValue(n2, (Object)InstrumentGraph$Values.PRICE_BAR, (Object)new PriceData(priceData.getOpen(), f2, f3, f4));
        dataSeries.setFloat(n2, (Object)InstrumentGraph$Values.OPEN, Float.valueOf(priceData.getOpen()));
        dataSeries.setFloat(n2, (Object)InstrumentGraph$Values.HIGH, Float.valueOf(f2));
        dataSeries.setFloat(n2, (Object)InstrumentGraph$Values.LOW, Float.valueOf(f3));
        dataSeries.setFloat(n2, (Object)InstrumentGraph$Values.CLOSE, Float.valueOf(f4));
        dataSeries.setDouble(n2, (Object)InstrumentGraph$Values.VOLUME, dataSeries.getDouble(n2, Enums.BarInput.VOLUME, instrument));
        dataSeries.setDouble(n2, (Object)InstrumentGraph$Values.OPEN_INTEREST, dataSeries.getDouble(n2, Enums.BarInput.OPEN_INTEREST, instrument));
        if (bl2) {
            this.notifyRangeUpdated();
        }
        this.notifyRedraw();
    };

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument", this.get("LBL_INSTRUMENT", new Object[0]))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new PriceBarDescriptor("priceBar", this.get("LBL_PRICE_BAR", new Object[0]), null, Enums.BarInput.CLOSE, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InstrumentGraph$Values.OPEN, this.get("LBL_OPEN", new Object[0]), new String[]{"instrument"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InstrumentGraph$Values.HIGH, this.get("LBL_HIGH", new Object[0]), new String[]{"instrument"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InstrumentGraph$Values.LOW, this.get("LBL_LOW", new Object[0]), new String[]{"instrument"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InstrumentGraph$Values.CLOSE, this.get("LBL_CLOSE", new Object[0]), new String[]{"instrument"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InstrumentGraph$Values.VOLUME, this.get("LBL_VOLUME", new Object[0]), new String[]{"instrument"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InstrumentGraph$Values.OPEN_INTEREST, this.get("LBL_OPEN_INTEREST", new Object[0]), new String[]{"instrument"}));
        runtimeDescriptor.declarePriceBar((Object)InstrumentGraph$Values.PRICE_BAR, "priceBar");
        runtimeDescriptor.declareIndicator((Object)InstrumentGraph$Values.CLOSE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{InstrumentGraph$Values.HIGH, InstrumentGraph$Values.LOW});
        runtimeDescriptor.getDefaultPlot().setFormatMK(false);
        runtimeDescriptor.setLabelSettings(new String[]{"instrument"});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        Instrument instrument = this.getSettings().getInstrument("instrument");
        if (instrument == null) {
            return;
        }
        this.getRuntimeDescriptor().setMinTick(Double.valueOf(instrument.getTickSize()));
        instrument.addListener(this.a);
    }

    protected void calculateValues(DataContext dataContext) {
        Instrument instrument;
        DataSeries dataSeries = dataContext.getDataSeries();
        if (!dataSeries.hasData(instrument = this.getSettings().getInstrument("instrument"))) {
            return;
        }
        this.a = dataContext;
        for (int i2 = 0; i2 < dataSeries.size(); ++i2) {
            float f2;
            if (dataSeries.isComplete(i2) || (f2 = dataSeries.getClose(i2, instrument)) == 0.0f) continue;
            dataSeries.setValue(i2, (Object)InstrumentGraph$Values.PRICE_BAR, (Object)new PriceData(dataSeries.getOpen(i2, instrument), dataSeries.getHigh(i2, instrument), dataSeries.getLow(i2, instrument), dataSeries.getClose(i2, instrument)));
            dataSeries.setFloat(i2, (Object)InstrumentGraph$Values.OPEN, dataSeries.getFloat(i2, Enums.BarInput.OPEN, instrument));
            dataSeries.setFloat(i2, (Object)InstrumentGraph$Values.HIGH, dataSeries.getFloat(i2, Enums.BarInput.HIGH, instrument));
            dataSeries.setFloat(i2, (Object)InstrumentGraph$Values.LOW, dataSeries.getFloat(i2, Enums.BarInput.LOW, instrument));
            dataSeries.setFloat(i2, (Object)InstrumentGraph$Values.CLOSE, dataSeries.getFloat(i2, Enums.BarInput.CLOSE, instrument));
            dataSeries.setDouble(i2, (Object)InstrumentGraph$Values.VOLUME, dataSeries.getDouble(i2, Enums.BarInput.VOLUME, instrument));
            dataSeries.setDouble(i2, (Object)InstrumentGraph$Values.OPEN_INTEREST, dataSeries.getDouble(i2, Enums.BarInput.OPEN_INTEREST, instrument));
            dataSeries.setComplete(i2);
        }
    }

    public String getLabel() {
        Instrument instrument = this.getSettings().getInstrument("instrument");
        if (instrument == null) {
            return super.getLabel();
        }
        PriceBarInfo priceBarInfo = this.getSettings().getPriceBar("priceBar");
        Object object = instrument.getSymbol();
        if (MWInstrument.hasMultiple((String)object)) {
            object = (String)object + ":" + instrument.getExchangeSymbol();
        }
        if (priceBarInfo == null || priceBarInfo.getType() == null) {
            return object;
        }
        if (priceBarInfo.getType().requiresInput()) {
            return (String)object + "(" + priceBarInfo.getBarInput() + ")";
        }
        return object;
    }
}

