/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.VIXTradingSystem$Signals;
import com.motivewave.platform.study.general3.VIXTradingSystem$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VIXTS", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VIXTS", name="NAME_VIX_TRADING_SYSTEM", desc="DESC_VIXTS", helpLink="http://www.motivewave.com/studies/vix_trading_system.htm", signals=true, overlay=true, studyOverlay=true)
public class VIXTradingSystem
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 50, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("COUNT", new Object[0]), 11, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_VIXTS", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("INPUT_PRICE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_VIXTS", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("INPUT_PRICE", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIXTradingSystem$Values.VIXTS, this.get("LBL_VIXTS", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIXTradingSystem$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VIXTradingSystem$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)VIXTradingSystem$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)VIXTradingSystem$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)VIXTradingSystem$Values.VIXTS, "line");
        runtimeDescriptor.declarePath((Object)VIXTradingSystem$Values.PRICE, "line2");
        runtimeDescriptor.declareIndicator((Object)VIXTradingSystem$Values.VIXTS, "ind");
        runtimeDescriptor.declareIndicator((Object)VIXTradingSystem$Values.PRICE, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{VIXTradingSystem$Values.VIXTS, VIXTradingSystem$Values.PRICE});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = n4 * -1;
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        dataSeries.setDouble(n2, (Object)VIXTradingSystem$Values.PRICE, Double.valueOf(d3));
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)VIXTradingSystem$Values.VIXTS, d4);
        if (n2 < n3 + 1) {
            return;
        }
        double d5 = dataSeries.getDouble(n2 - 1, (Object)VIXTradingSystem$Values.COUNT, 0.0);
        if (d3 > d4 && d5 >= 0.0) {
            d2 = d5 + 1.0;
        }
        if (d3 <= d4 && d5 <= 0.0) {
            d2 = d5 - 1.0;
        }
        dataSeries.setDouble(n2, (Object)VIXTradingSystem$Values.COUNT, Double.valueOf(d2));
        boolean bl2 = d2 == (double)n4;
        boolean bl3 = d2 == (double)n5;
        dataSeries.setBoolean(n2, (Object)VIXTradingSystem$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)VIXTradingSystem$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_VIXTS", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d4, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)VIXTradingSystem$Signals.SELL, string, (Object)d3);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_VIXTS", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d4, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)VIXTradingSystem$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

