/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.ColorInfo;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.SectorRotationModel$Values;

@StudyHeader(namespace="com.motivewave", id="ID_SECROTMOD", rb="com.motivewave.platform.study.nls.strings2", name="NAME_SECTOR_ROTATION_MODEL", label="LBL_SECROTMOD", desc="DESC_SECROTMOD", helpLink="http://www.motivewave.com/studies/sector_rotation_model.htm", overlay=false, multipleInstrument=true, requiresBarUpdates=true)
public class SectorRotationModel
extends Study {
    static final String a = "Instr5";
    static final int a = 1440;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object[])Enums.BarInput.values(), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("ROC_PERIOD", new Object[0]), 75, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument1", this.get("SELECT_FINANCIAL_(XLF)", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument2", this.get("SELECT_CONSUMER_DISCRETIONARY_(XLY)", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument3", this.get("SELECT_ENERGY_(XLE)", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument4", this.get("SELECT_UTILITIES_(XLU)", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor(a, this.get("SELECT_CONSUMER_STAPLES_(XLP)", new Object[0]))});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("COLORS", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("DISPLAY", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("UP_COLOR", new Object[0]), defaults.getGreen(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("DOWN_COLOR", new Object[0]), defaults.getRed(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SectorRotationModel$Values.OSC, this.get("LBL_SECROTMOD", new Object[0]), new String[]{"instrument1", "instrument2", "instrument3", "instrument4", a}));
        runtimeDescriptor.setLabelSettings(new String[]{"instrument1", "instrument2", "instrument3", "instrument4", a});
        runtimeDescriptor.declareBars((Object)SectorRotationModel$Values.OSC, null);
        runtimeDescriptor.declareIndicator((Object)SectorRotationModel$Values.OSC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{SectorRotationModel$Values.OSC});
        runtimeDescriptor.getDefaultPlot().setFormatMK(false);
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 <= n3) {
            return;
        }
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input");
        Instrument instrument = this.getSettings().getInstrument("instrument1");
        Instrument instrument2 = this.getSettings().getInstrument("instrument2");
        Instrument instrument3 = this.getSettings().getInstrument("instrument3");
        Instrument instrument4 = this.getSettings().getInstrument("instrument4");
        Instrument instrument5 = this.getSettings().getInstrument(a);
        ColorInfo colorInfo = this.getSettings().getColorInfo("upColor");
        ColorInfo colorInfo2 = this.getSettings().getColorInfo("downColor");
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = dataSeries.getBarSize();
        int n4 = barSize.getIntervalMinutes();
        if (n4 != 1440) {
            return;
        }
        Double d2 = dataSeries.roc(n2, n3, barInput, instrument);
        if (d2 == null) {
            return;
        }
        Double d3 = dataSeries.roc(n2, n3, barInput, instrument2);
        if (d3 == null) {
            return;
        }
        Double d4 = dataSeries.roc(n2, n3, barInput, instrument3);
        if (d4 == null) {
            return;
        }
        Double d5 = dataSeries.roc(n2, n3, barInput, instrument4);
        if (d5 == null) {
            return;
        }
        Double d6 = dataSeries.roc(n2, n3, barInput, instrument5);
        if (d6 == null) {
            return;
        }
        double d7 = (d4 + d5 + d6) / 3.0;
        double d8 = (d2 + d3) / 2.0;
        double d9 = 100.0 * (d8 - d7);
        dataSeries.setDouble(n2, (Object)SectorRotationModel$Values.OSC, Double.valueOf(d9));
        if (colorInfo.isEnabled() && d9 >= 0.0) {
            dataSeries.setBarColor(n2, (Object)SectorRotationModel$Values.OSC, colorInfo.getColor());
        }
        if (colorInfo2.isEnabled() && d9 < 0.0) {
            dataSeries.setBarColor(n2, (Object)SectorRotationModel$Values.OSC, colorInfo2.getColor());
        }
    }
}

