/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.MultiLevelInd$Signals;
import com.motivewave.platform.study.general3.MultiLevelInd$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_MULTI_LEVEL", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MULTI_LEVEL_INDICATOR", label="LBL_MULTL", desc="DESC_MULTL", helpLink="http://www.motivewave.com/studies/multi_level_indicator.htm", overlay=false, signals=true)
public class MultiLevelInd
extends Study {
    static final String[] a = new String[]{"05 min", "15 min", "30 min", "60 min"};
    boolean a = true;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("SIGNAL_LEVEL_TIME_FRAME", new Object[0]), (Object[])a, (Object)a[0])});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FACTOR", new Object[0]), 10000, 1, 99999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 10.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -10.0, 0.0, -999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MultiLevelInd$Values.Z, this.get("LBL_MULTL", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MultiLevelInd$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MultiLevelInd$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)MultiLevelInd$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MultiLevelInd$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.declarePath((Object)MultiLevelInd$Values.Z, "line");
        runtimeDescriptor.declareIndicator((Object)MultiLevelInd$Values.Z, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MultiLevelInd$Values.Z});
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(60);
    }

    public void onBarClose(DataContext dataContext) {
        this.calculateValues(dataContext);
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = dataSeries.getBarSize();
        int n2 = barSize.getIntervalMinutes();
        if (n2 != 1) {
            return;
        }
        String string = (String)this.getSettings().getInput("input");
        int n3 = Integer.valueOf(string.substring(0, 2));
        int n4 = this.getSettings().getInteger("period");
        int n5 = dataSeries.size();
        if (n5 < n3) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = n3; i2 < n5; ++i2) {
            String string2;
            MarkerInfo markerInfo;
            Coordinate coordinate;
            d2 = dataSeries.getClose(i2);
            d3 = dataSeries.getOpen(i2);
            d4 = dataSeries.getOpen(i2 - n3);
            d5 = (d2 - d3 - (d2 - d4)) * (double)n4;
            dataSeries.setDouble(i2, (Object)MultiLevelInd$Values.Z, Double.valueOf(d5));
            GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
            double d6 = guideInfo.getValue();
            GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
            double d7 = guideInfo2.getValue();
            double d8 = dataSeries.getDouble(i2 - 1, (Object)MultiLevelInd$Values.Z, d5);
            boolean bl2 = d8 < d6 && d5 > d6;
            boolean bl3 = d8 > d7 && d5 < d7;
            dataSeries.setBoolean(i2, (Object)MultiLevelInd$Signals.BUY, Boolean.valueOf(bl3));
            dataSeries.setBoolean(i2, (Object)MultiLevelInd$Signals.SELL, Boolean.valueOf(bl2));
            if (bl2) {
                coordinate = new Coordinate(dataSeries.getStartTime(i2), d5);
                markerInfo = this.getSettings().getMarker("downMarker");
                string2 = this.get("SELL_CLOSE_Z", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
                if (markerInfo.isEnabled()) {
                    this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string2));
                }
                dataContext.signal(i2, (Object)MultiLevelInd$Signals.SELL, string2, (Object)d2);
            }
            if (bl3) {
                coordinate = new Coordinate(dataSeries.getStartTime(i2), d5);
                markerInfo = this.getSettings().getMarker("upMarker");
                string2 = this.get("BUY_CLOSE_Z", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
                if (markerInfo.isEnabled()) {
                    this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string2));
                }
                dataContext.signal(i2, (Object)MultiLevelInd$Signals.BUY, string2, (Object)d2);
            }
            dataSeries.setComplete(i2);
        }
    }
}

