/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.n;
import com.motivewave.platform.study.general3.LinearRegCurve$Signals;
import com.motivewave.platform.study.general3.LinearRegCurve$Values;

@StudyHeader(namespace="com.motivewave", id="ID_LINEAR_REG_CURVE", rb="com.motivewave.platform.study.nls.strings2", name="NAME_LINEAR_REGRESSION_CURVE", label="LBL_LREGCRV", desc="DESC_LIN_REG_CURVE", helpLink="http://www.motivewave.com/studies/linear_regression_curve.htm", overlay=true, signals=true, studyOverlay=true)
public class LinearRegCurve
extends Study {
    static final String a = "PercentA";
    static final String b = "PercentB";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("PERCENT_ABOVE", new Object[0]), 0.009, 0.0, 9.001, 0.001)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("PERCENT_BELOW", new Object[0]), 0.009, 0.0, 9.001, 0.001)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LINEAR_REGRESSION", new Object[0]), defaults.getBlue(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("PRICE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LINEAR_REGRESSION", new Object[0]), defaults.getBlue(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("PRICE", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LinearRegCurve$Values.LINREG, this.get("LBL_LREGCRV", new Object[0]), new String[]{"input", "period", a, b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LinearRegCurve$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LinearRegCurve$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)LinearRegCurve$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)LinearRegCurve$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)LinearRegCurve$Values.LINREG, "line");
        runtimeDescriptor.declarePath((Object)LinearRegCurve$Values.PRICE, "line2");
        runtimeDescriptor.declareIndicator((Object)LinearRegCurve$Values.LINREG, "ind");
        runtimeDescriptor.declareIndicator((Object)LinearRegCurve$Values.PRICE, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{LinearRegCurve$Values.LINREG, LinearRegCurve$Values.PRICE});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        double d2 = this.getSettings().getDouble(a);
        double d3 = this.getSettings().getDouble(b);
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = n.a(dataSeries, n2, n3, object, n3)[0];
        dataSeries.setDouble(n2, (Object)LinearRegCurve$Values.LINREG, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)LinearRegCurve$Values.PRICE, Double.valueOf(d4));
        d2 = 1.0 + d2 / 100.0;
        d3 = 1.0 - d3 / 100.0;
        boolean bl2 = d4 > d5 * d2;
        boolean bl3 = d4 < d5 * d3;
        dataSeries.setBoolean(n2, (Object)LinearRegCurve$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)LinearRegCurve$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_LINREG", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)LinearRegCurve$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_LINREG", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)LinearRegCurve$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

