/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.LaguerreRSI$Values;

@StudyHeader(namespace="com.motivewave", id="ID_LAG_RSI", rb="com.motivewave.platform.study.nls.strings2", label="LBL_LAGRSI", name="NAME_LAGUERRE_RSI", desc="DESC_LAGRSI", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/laguerre_rsi.htm", signals=false, overlay=false, studyOverlay=true)
public class LaguerreRSI
extends Study {
    static final String a = "Gamma";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("GAMMA", new Object[0]), 0.5, 0.1, 1.0, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.8, 0.01, 1.0, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.5, 0.01, 1.0, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 0.2, 0.01, 1.0, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LaguerreRSI$Values.RSI, this.get("LBL_LAGRSI", new Object[0]), new String[]{"input", a}));
        runtimeDescriptor.declarePath((Object)LaguerreRSI$Values.RSI, "line");
        runtimeDescriptor.declareIndicator((Object)LaguerreRSI$Values.RSI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{LaguerreRSI$Values.RSI});
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(21);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, (Object)LaguerreRSI$Values.R_L0, d3);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)LaguerreRSI$Values.R_L1, d3);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)LaguerreRSI$Values.R_L2, d3);
        double d7 = dataSeries.getDouble(n2 - 1, (Object)LaguerreRSI$Values.R_L3, d3);
        double d8 = (1.0 - d2) * d3 + d2 * d4;
        double d9 = -d2 * d8 + d4 + d2 * d5;
        double d10 = -d2 * d9 + d5 + d2 * d6;
        double d11 = -d2 * d10 + d6 + d2 * d7;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        if (d8 >= d9) {
            d12 = d8 - d9;
        } else {
            d13 = d9 - d8;
        }
        if (d9 >= d10) {
            d12 = d12 + d9 - d10;
        } else {
            d13 = d13 + d10 - d9;
        }
        if (d10 >= d11) {
            d12 = d12 + d10 - d11;
        } else {
            d13 = d13 + d11 - d10;
        }
        if (d12 + d13 != 0.0) {
            d14 = d12 / (d12 + d13);
        }
        dataSeries.setDouble(n2, (Object)LaguerreRSI$Values.RSI, Double.valueOf(d14));
        dataSeries.setDouble(n2, (Object)LaguerreRSI$Values.R_L0, Double.valueOf(d8));
        dataSeries.setDouble(n2, (Object)LaguerreRSI$Values.R_L1, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)LaguerreRSI$Values.R_L2, Double.valueOf(d10));
        dataSeries.setDouble(n2, (Object)LaguerreRSI$Values.R_L3, Double.valueOf(d11));
        dataSeries.setComplete(n2);
    }
}

