/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.LaguerreCombo$Values;

@StudyHeader(namespace="com.motivewave", id="ID_LAG_COMBO", rb="com.motivewave.platform.study.nls.strings2", label="LBL_LAGCOMBO", name="NAME_LAGUERRE_COMBO", desc="DESC_LAGCOMBO", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/laguerre_combo.htm", signals=false, overlay=false, studyOverlay=true)
public class LaguerreCombo
extends Study {
    static final String a = "Gamma";
    static final String b = "Alpha";
    static final String c = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("RSI_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("RSI_GAMMA", new Object[0]), 0.5, 0.1, 1.0, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("FILTER_INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("FILTER_ALPHA", new Object[0]), 0.2, 0.0, 0.99, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("RSI_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("RSI_PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("RSI_INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("FILTER_PATHS_AND_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("FILTER_PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("FIR_PATH", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("FILTER_INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("FIR_INDICATOR", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.8, 0.01, 1.0, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.5, 0.01, 1.0, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 0.2, 0.01, 1.0, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.setLabelPrefix("LAGRSI");
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)LaguerreCombo$Values.RSI, this.get("LBL_LRSI", new Object[0]), new String[]{"input", a}));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{"input2", b});
        runtimeDescriptor.getPricePlot().setLabelPrefix("LAGFILT");
        runtimeDescriptor.getPricePlot().declarePath((Object)LaguerreCombo$Values.FILT, "line2");
        runtimeDescriptor.getPricePlot().declarePath((Object)LaguerreCombo$Values.FIR, "line3");
        runtimeDescriptor.getPricePlot().declareIndicator((Object)LaguerreCombo$Values.FILT, "ind2");
        runtimeDescriptor.getPricePlot().declareIndicator((Object)LaguerreCombo$Values.FIR, c);
        runtimeDescriptor.getPricePlot().setRangeKeys(new Object[]{LaguerreCombo$Values.FILT, LaguerreCombo$Values.FIR});
        runtimeDescriptor.declarePath((Object)LaguerreCombo$Values.RSI, "line");
        runtimeDescriptor.declareIndicator((Object)LaguerreCombo$Values.RSI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{LaguerreCombo$Values.RSI});
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(21);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a);
        Object object2 = this.getSettings().getInput("input2", (Object)Enums.BarInput.MIDPOINT);
        double d3 = this.getSettings().getDouble(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.R_L0, d4);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.R_L1, d4);
        double d7 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.R_L2, d4);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.R_L3, d4);
        double d9 = (1.0 - d2) * d4 + d2 * d5;
        double d10 = -d2 * d9 + d5 + d2 * d6;
        double d11 = -d2 * d10 + d6 + d2 * d7;
        double d12 = -d2 * d11 + d7 + d2 * d8;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        if (d9 >= d10) {
            d13 = d9 - d10;
        } else {
            d14 = d10 - d9;
        }
        if (d10 >= d11) {
            d13 = d13 + d10 - d11;
        } else {
            d14 = d14 + d11 - d10;
        }
        if (d11 >= d12) {
            d13 = d13 + d11 - d12;
        } else {
            d14 = d14 + d12 - d11;
        }
        if (d13 + d14 != 0.0) {
            d15 = d13 / (d13 + d14);
        }
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.RSI, Double.valueOf(d15));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.R_L0, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.R_L1, Double.valueOf(d10));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.R_L2, Double.valueOf(d11));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.R_L3, Double.valueOf(d12));
        double d16 = dataSeries.getDouble(n2, object2, 0.0);
        double d17 = dataSeries.getDouble(n2 - 1, object2, 0.0);
        double d18 = dataSeries.getDouble(n2 - 2, object2, 0.0);
        double d19 = dataSeries.getDouble(n2 - 3, object2, 0.0);
        double d20 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.F_L0, d16);
        double d21 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.F_L1, d16);
        double d22 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.F_L2, d16);
        double d23 = dataSeries.getDouble(n2 - 1, (Object)LaguerreCombo$Values.F_L3, d16);
        double d24 = d3 * d16 + (1.0 - d3) * d20;
        double d25 = -(1.0 - d3) * d24 + d20 + (1.0 - d3) * d21;
        double d26 = -(1.0 - d3) * d25 + d21 + (1.0 - d3) * d22;
        double d27 = -(1.0 - d3) * d26 + d22 + (1.0 - d3) * d23;
        double d28 = (d24 + 2.0 * d25 + 2.0 * d26 + d27) / 6.0;
        double d29 = (d16 + 2.0 * d17 + 2.0 * d18 + d19) / 6.0;
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.FILT, Double.valueOf(d28));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.FIR, Double.valueOf(d29));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.F_L0, Double.valueOf(d24));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.F_L1, Double.valueOf(d25));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.F_L2, Double.valueOf(d26));
        dataSeries.setDouble(n2, (Object)LaguerreCombo$Values.F_L3, Double.valueOf(d27));
        dataSeries.setComplete(n2);
    }
}

