/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.DMIStochastic$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="DMI_STOCHASTIC", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DMI_STOCHASTIC", desc="DESC_DMI_STOCH", label="LBL_DMIST", helpLink="http://www.motivewave.com/studies/dmi_stochastic.htm", overlay=false, studyOverlay=true)
public class DMIStochastic
extends Study {
    static final String a = "Period5";
    static final String b = "dmiOscPath";
    static final String c = "dmiOscInd";
    static final String d = "dmiStochPath";
    static final String e = "dmiStochInd";
    static final String f = "maPath";
    static final String g = "maInd";
    static final String h = "dmiStochTopG";
    static final String i = "dmiStochMidG";
    static final String j = "dmiStochBottG";
    static final String k = "upColor";
    static final String l = "downColor";
    static final String m = "dmiStochPlot";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("DMI_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("DMI_STOCH_FAST_K_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("DMI_STOCH_SLOW_K_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("DMI_STOCH_SMOOTH_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("STOCHASTIC_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("MA_PERIOD", new Object[0]), 50, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("MA_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingTab.addGroup(settingGroup);
        SettingTab settingTab2 = new SettingTab(this.get("COLORS", new Object[0]));
        settingsDescriptor.addTab(settingTab2);
        SettingGroup settingGroup2 = new SettingGroup(this.get("DMI_OSCILLATOR_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("DMI_OSCILLATOR_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("DMI_OSCILLATOR_INDICATOR", new Object[0]), defaults.getBlue(), Color.WHITE, false, true, true)});
        settingTab2.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("DMI_STOCHASTIC_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("DMI_STOCHASTIC_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("DMI_STOCHASTIC_INDICATOR", new Object[0]), defaults.getBlue(), Color.WHITE, false, true, true)});
        settingTab2.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("MA_PATH_AND_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(f, this.get("MA_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("MA_INDICATOR", new Object[0]), defaults.getBlue(), Color.WHITE, false, true, true)});
        settingTab2.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("DMI_OSC_BAR_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(k, this.get("UP_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(l, this.get("DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingTab2.addGroup(settingGroup2);
        SettingTab settingTab3 = new SettingTab(this.get("GUIDES", new Object[0]));
        settingsDescriptor.addTab(settingTab3);
        SettingGroup settingGroup3 = new SettingGroup(this.get("DMI_OSCILLATOR_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("DMI_OSC_TOP_GUIDE", new Object[0]), 20.0, 0.0, 999.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("DMI_OSC_MIDDLE_GUIDE", new Object[0]), 0.0, -999.0, 999.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("DMI_OSC_BOTTOM_GUIDE", new Object[0]), -20.0, 0.0, -999.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab3.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("DMI_STOCHASTIC_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor4 = new GuideDescriptor(h, this.get("DMI_STOCH_TOP_GUIDE", new Object[0]), 90.0, 0.0, 999.1, 0.1, true);
        guideDescriptor4.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor4});
        GuideDescriptor guideDescriptor5 = new GuideDescriptor(i, this.get("DMI_STOCH_MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor5.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor5});
        GuideDescriptor guideDescriptor6 = new GuideDescriptor(j, this.get("DMI_STOCH_BOTTOM_GUIDE", new Object[0]), 10.0, 0.0, 999.1, 0.1, true);
        guideDescriptor6.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor6});
        settingTab3.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMIStochastic$Values.DMI_OSC, this.get("DMI_OSC", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMIStochastic$Values.DMI_STOCH, this.get("DMI_STOCH", new Object[0]), new String[]{"period2", "period3", "period4", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMIStochastic$Values.MA, this.get("MA", new Object[0]), new String[]{a, "method2"}));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.getPricePlot().setLabelPrefix(this.get("MA", new Object[0]));
        runtimeDescriptor.getPricePlot().declarePath((Object)DMIStochastic$Values.MA, f);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)DMIStochastic$Values.MA, g);
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.setLabelPrefix(this.get("DMI_OSC", new Object[0]));
        runtimeDescriptor.setTabName(this.get("DMI_OSC", new Object[0]));
        runtimeDescriptor.declarePath((Object)DMIStochastic$Values.DMI_OSC, b);
        runtimeDescriptor.declareBars((Object)DMIStochastic$Values.DMI_OSC);
        runtimeDescriptor.declareIndicator((Object)DMIStochastic$Values.DMI_OSC, c);
        runtimeDescriptor.getDefaultPlot().declareGuide("topGuide");
        runtimeDescriptor.getDefaultPlot().declareGuide("middleGuide");
        runtimeDescriptor.getDefaultPlot().declareGuide("bottomGuide");
        runtimeDescriptor.setRangeKeys(new Object[]{DMIStochastic$Values.DMI_OSC});
        Plot plot = new Plot();
        runtimeDescriptor.addPlot(m, plot);
        plot.setLabelSettings(new String[]{"input", "period2", "period3", "period4"});
        plot.setLabelPrefix(this.get("DMI_STOCH", new Object[0]));
        plot.setTabName(this.get("DMI_STOCH", new Object[0]));
        plot.declarePath((Object)DMIStochastic$Values.DMI_STOCH, d);
        plot.declareIndicator((Object)DMIStochastic$Values.DMI_STOCH, e);
        plot.declareGuide(h);
        plot.declareGuide(i);
        plot.declareGuide(j);
        plot.setRangeKeys(new Object[]{DMIStochastic$Values.DMI_STOCH});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        int n6 = this.getSettings().getInteger(a);
        int n7 = Math.max(Math.max(Math.max(Math.max(n2, n3), n4), n5), n6);
        this.setMinBars(n7);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period");
        int n5 = this.getSettings().getInteger("period2");
        int n6 = this.getSettings().getInteger("period3");
        int n7 = this.getSettings().getInteger("period4");
        int n8 = this.getSettings().getInteger(a);
        int n9 = Math.max(Math.max(Math.max(Math.max(n4, n5), n6), n7), n8);
        if (n2 < n9) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2");
        Color color = this.getSettings().getColor(k);
        Color color2 = this.getSettings().getColor(l);
        DataSeries dataSeries = dataContext.getDataSeries();
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        if (f2 == null || f3 == null || f4 == null) {
            return;
        }
        dataSeries.setFloat(n2, (Object)DMIStochastic$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)DMIStochastic$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)DMIStochastic$Values.TR, f4);
        Double d2 = dataSeries.smma(n2, n4, (Object)DMIStochastic$Values.PDM);
        Double d3 = dataSeries.smma(n2, n4, (Object)DMIStochastic$Values.NDM);
        Double d4 = dataSeries.smma(n2, n4, (Object)DMIStochastic$Values.TR);
        if (d2 == null || d3 == null || d4 == null) {
            return;
        }
        double d5 = d2 / d4 * 100.0;
        double d6 = d3 / d4 * 100.0;
        double d7 = d5 - d6;
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.DMI_OSC, Double.valueOf(d7));
        if (n2 < n9 + n5) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d8 = guideInfo.getValue();
        if (d7 > d8) {
            dataSeries.setBarColor(n2, (Object)DMIStochastic$Values.DMI_OSC, color);
        } else {
            dataSeries.setBarColor(n2, (Object)DMIStochastic$Values.DMI_OSC, color2);
        }
        double d9 = dataSeries.lowest(n2, n5, (Object)DMIStochastic$Values.DMI_OSC);
        double d10 = dataSeries.highest(n2, n5, (Object)DMIStochastic$Values.DMI_OSC);
        double d11 = (d7 - d9) / (d10 - d9) * 100.0;
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.FAST_K, Double.valueOf(d11));
        if (n2 < n9 + n5 + n6) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n6, (Object)DMIStochastic$Values.FAST_K);
        if (d12 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.SLOW_K, d12);
        if (n2 < n9 + n5 + n6) {
            return;
        }
        Double d13 = dataSeries.ma(mAMethod, n2, n7, (Object)DMIStochastic$Values.SLOW_K);
        if (d13 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.DMI_STOCH, d13);
        Double d14 = dataSeries.ma(mAMethod2, n2, n8, object);
        if (d14 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.MA, d14);
        dataSeries.setComplete(n2);
    }
}

