/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.PriceData;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PriceBarDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.ChartmillValueInd$Values;
import com.motivewave.platform.study.general3.b;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_CHARTMILL_VALUE", rb="com.motivewave.platform.study.nls.strings2", label="LBL_CMVI", name="NAME_CHARTMILL_VALUE_INDICATOR", desc="DESC_CMVI", helpLink="http://www.motivewave.com/studies/chartmill_value_indicator.htm", signals=false, overlay=false, studyOverlay=true)
public class ChartmillValueInd
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(b.d, this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b.g, this.get("PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new PriceBarDescriptor("priceBar", this.get("LBL_PRICE_BAR", new Object[0]), null, Enums.BarInput.CLOSE, true, false)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor(b.B, this.get("TOP_GUIDE", new Object[0]), 2.0, 0.0, 99.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup2.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor(b.C, this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -99.0, 99.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup2.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor(b.D, this.get("BOTTOM_GUIDE", new Object[0]), -2.0, -99.0, 0.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup2.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{b.d, b.g});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChartmillValueInd$Values.CMVO, this.get("OPEN", new Object[0]), new String[]{b.d, b.g}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChartmillValueInd$Values.CMVH, this.get("HIGH", new Object[0]), new String[]{b.d, b.g}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChartmillValueInd$Values.CMVL, this.get("LOW", new Object[0]), new String[]{b.d, b.g}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChartmillValueInd$Values.CMVC, this.get("CLOSE", new Object[0]), new String[]{b.d, b.g}));
        runtimeDescriptor.declarePriceBar((Object)ChartmillValueInd$Values.PRICE_BAR, "priceBar");
        runtimeDescriptor.setRangeKeys(new Object[]{ChartmillValueInd$Values.CMVH, ChartmillValueInd$Values.CMVL});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger(b.g);
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(b.g);
        if (n2 < n3 + 1) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod(b.d);
        DataSeries dataSeries = dataContext.getDataSeries();
        float f2 = dataSeries.getClose(n2);
        float f3 = dataSeries.getHigh(n2);
        float f4 = dataSeries.getLow(n2);
        float f5 = dataSeries.getOpen(n2);
        Double d2 = dataSeries.ma(mAMethod, n2, n3, (Object)Enums.BarInput.MIDPOINT);
        Double d3 = dataSeries.ma(mAMethod, n2, n3, (Object)Enums.BarInput.TR);
        if (d2 == null || d3 == null || d3 == 0.0) {
            return;
        }
        float f6 = d3.floatValue();
        float f7 = d2.floatValue();
        float f8 = (f2 - f7) / f6;
        float f9 = (f3 - f7) / f6;
        float f10 = (f4 - f7) / f6;
        float f11 = (f5 - f7) / f6;
        dataSeries.setFloat(n2, (Object)ChartmillValueInd$Values.CMVO, Float.valueOf(f11));
        dataSeries.setFloat(n2, (Object)ChartmillValueInd$Values.CMVH, Float.valueOf(f9));
        dataSeries.setFloat(n2, (Object)ChartmillValueInd$Values.CMVL, Float.valueOf(f10));
        dataSeries.setFloat(n2, (Object)ChartmillValueInd$Values.CMVC, Float.valueOf(f8));
        float f12 = dataSeries.getFloat(n2 - 1, (Object)ChartmillValueInd$Values.CMVH, f9);
        float f13 = dataSeries.getFloat(n2 - 1, (Object)ChartmillValueInd$Values.CMVL, f10);
        Color color = null;
        if (f11 > f8) {
            color = X11Colors.RED;
        }
        if (f11 < f8) {
            color = X11Colors.GREEN;
        }
        if (f9 > f12 && f10 < f13) {
            color = X11Colors.BLUE;
        }
        if (f9 < f12 && f10 > f13 || f11 == f8) {
            color = dataContext.getDefaults().getLineColor();
        }
        dataSeries.setValue(n2, (Object)ChartmillValueInd$Values.PRICE_BAR, (Object)new PriceData(f11, f9, f10, f8, color));
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

