/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.VolatilityRatio$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VLT_RATIO", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VR", menu="MENU_GENERAL", name="NAME_VOLATILITY_RATIO", desc="DESC_VR", signals=false, overlay=false, studyOverlay=true)
public class VolatilityRatio
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VolatilityRatio$Values.VR, this.get("LBL_VR", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.declarePath((Object)VolatilityRatio$Values.VR, "line");
        runtimeDescriptor.declareIndicator((Object)VolatilityRatio$Values.VR, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{VolatilityRatio$Values.VR});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getClose(n2 - 1);
        double d5 = Math.max(Math.max(d2 - d3, d2 - d4), d4 - d3);
        dataSeries.setDouble(n2, (Object)VolatilityRatio$Values.TR, Double.valueOf(d5));
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)VolatilityRatio$Values.TR);
        if (d6 == null) {
            return;
        }
        double d7 = d5 / d6;
        dataSeries.setDouble(n2, (Object)VolatilityRatio$Values.VR, Double.valueOf(d7));
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

