/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.TreynorRatio$Values;

@StudyHeader(namespace="com.motivewave", id="ID_TREYNOR", rb="com.motivewave.platform.study.nls.strings2", label="LBL_TREYNOR", name="NAME_TREYNOR_RATIO", desc="DESC_TREYNOR", helpLink="http://www.motivewave.com/studies/treynor_ratio.htm", signals=false, overlay=false, studyOverlay=true)
public class TreynorRatio
extends Study {
    static final String a = "Safe";
    static final String b = "Beta";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 30, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("BETA", new Object[0]), 1.0, -1.01, 1.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("SAFE_RETURN_%", new Object[0]), 2.0, 0.0, 99.01, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_TREYNOR", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.01, 9.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", b, a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TreynorRatio$Values.TREYNOR, this.get("LBL_TREYNOR", new Object[0]), new String[]{"input", "period", b, a}));
        runtimeDescriptor.declarePath((Object)TreynorRatio$Values.TREYNOR, "line");
        runtimeDescriptor.declareIndicator((Object)TreynorRatio$Values.TREYNOR, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{TreynorRatio$Values.TREYNOR});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a);
        double d3 = this.getSettings().getDouble(b);
        d2 /= 100.0;
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = 0.0;
        int n4 = 0;
        BarSize barSize = dataSeries.getBarSize();
        if (barSize.getType() != Enums.BarSizeType.LINEAR) {
            return;
        }
        n4 = barSize.getIntervalMinutes();
        double d5 = 518400.0;
        double d6 = d5 / (double)n4;
        double d7 = Math.pow(1.0 + d2, (double)n3 / d6) - 1.0;
        double d8 = dataSeries.getDouble(n2, object, 0.0);
        double d9 = dataSeries.getDouble(n2 - n3, object, 0.0);
        double d10 = d8 / d9 - 1.0;
        dataSeries.setDouble(n2, (Object)TreynorRatio$Values.RET, Double.valueOf(d10));
        if (n2 < n3 * 2) {
            return;
        }
        double d11 = dataSeries.sma(n2, n3, (Object)TreynorRatio$Values.RET);
        d4 = (d11 - d7) / d3;
        dataSeries.setDouble(n2, (Object)TreynorRatio$Values.TREYNOR, Double.valueOf(d4));
        dataSeries.setComplete(n2);
    }
}

