/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.TechnicalRank$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_TRANK", rb="com.motivewave.platform.study.nls.strings2", label="LBL_TRANK", name="NAME_TECHNICAL_RANK", desc="DESC_TRANK", helpLink="http://www.motivewave.com/studies/technical_rank.htm", signals=false, overlay=false, studyOverlay=true)
public class TechnicalRank
extends Study {
    static final String a = "Period5";
    static final String b = "Period6";
    static final String c = "Period7";
    static final String d = "Period8";
    static final String e = "Period9";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LONG_TERM_SMA_PERIOD1", new Object[0]), 200, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LONG_TERM_ROC_PERIOD2", new Object[0]), 125, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("MID_TERM_SMA_PERIOD3", new Object[0]), 50, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("MID_TERM_ROC_PERIOD4", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("SHORT_TERM_PPOH_MA5_PERIOD5", new Object[0]), 12, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("SHORT_TERM_PPOH_MA6_PERIOD6", new Object[0]), 26, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("SHORT_TERM_PPOH_SIG_PERIOD7", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("SHORT_TERM_PPOH_SLOPE_PERIOD8", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(e, this.get("SHORT_TERM_RSI_PERIOD9", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("RSI_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("topColor", this.get("TOP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("MID_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("bottomColor", this.get("BOTTOM_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, -99.1, 99.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", a, b, c, d, e, "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TechnicalRank$Values.TR, this.get("LBL_TRANK", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", a, b, c, d, e}));
        runtimeDescriptor.declareBars((Object)TechnicalRank$Values.TR);
        runtimeDescriptor.declareIndicator((Object)TechnicalRank$Values.TR, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{TechnicalRank$Values.TR});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        int n6 = this.getSettings().getInteger(a);
        int n7 = this.getSettings().getInteger(b);
        int n8 = this.getSettings().getInteger(c);
        int n9 = this.getSettings().getInteger(d);
        int n10 = this.getSettings().getInteger(e);
        this.setMinBars(Math.max(Math.max(Math.max(Math.max(Math.max(Math.max(Math.max(Math.max(n2, n3), n4), n5), n6), n7), n8), n9), n10));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        int n7 = this.getSettings().getInteger(a);
        int n8 = this.getSettings().getInteger(b);
        int n9 = this.getSettings().getInteger(c);
        int n10 = this.getSettings().getInteger(d);
        int n11 = this.getSettings().getInteger(e);
        int n12 = Math.max(Math.max(Math.max(Math.max(Math.max(Math.max(Math.max(Math.max(n3, n4), n5), n6), n7), n8), n9), n10), n11);
        if (n2 < n12) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.sma(n2, n3, object);
        double d4 = 30.0 * (d2 - d3) / d3;
        double d5 = 30.0 * dataSeries.roc(n2, n4, object);
        double d6 = dataSeries.sma(n2, n5, object);
        double d7 = 15.0 * (d2 - d6) / d6;
        double d8 = 15.0 * dataSeries.roc(n2, n6, object);
        Double d9 = dataSeries.ma(Enums.MAMethod.EMA, n2, n7, object);
        if (d9 == null) {
            return;
        }
        Double d10 = dataSeries.ma(Enums.MAMethod.EMA, n2, n8, object);
        if (d10 == null) {
            return;
        }
        double d11 = 100.0 * (d9 - d10) / d10;
        Double d12 = dataSeries.ma(Enums.MAMethod.EMA, n2, n9, object);
        if (d12 == null) {
            return;
        }
        double d13 = d11 - d12;
        dataSeries.setDouble(n2, (Object)TechnicalRank$Values.PPO_HIST, Double.valueOf(d13));
        if (n2 < n12 + n10) {
            return;
        }
        double d14 = dataSeries.getDouble(n2, (Object)TechnicalRank$Values.PPO_HIST, 0.0);
        double d15 = dataSeries.getDouble(n2 - n10, (Object)TechnicalRank$Values.PPO_HIST, 0.0);
        double d16 = (d14 - d15) / (double)n10;
        double d17 = 5.0 * d16;
        double d18 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d19 = 0.0;
        double d20 = 0.0;
        if (d18 > 0.0) {
            d19 = d18;
        } else {
            d20 = d18;
        }
        dataSeries.setDouble(n2, (Object)TechnicalRank$Values.UP, Double.valueOf(d19));
        dataSeries.setDouble(n2, (Object)TechnicalRank$Values.DOWN, Double.valueOf(Math.abs(d20)));
        if (n2 < n11 + n12 + n10) {
            return;
        }
        Double d21 = dataSeries.ma(mAMethod, n2, n11, (Object)TechnicalRank$Values.UP);
        if (d21 == null) {
            return;
        }
        Double d22 = dataSeries.ma(mAMethod, n2, n11, (Object)TechnicalRank$Values.DOWN);
        if (d22 == null) {
            return;
        }
        double d23 = d21 / d22;
        double d24 = 100.0 - 100.0 / (1.0 + d23);
        double d25 = 0.05 * d24;
        double d26 = d4 + d5 + d7 + d8 + d17 + d25;
        if ((d26 = Util.round((double)d26, (int)2)) < 0.0) {
            d26 = 0.0;
        }
        if (d26 > 100.0) {
            d26 = 100.0;
        }
        dataSeries.setDouble(n2, (Object)TechnicalRank$Values.TR, Double.valueOf(d26));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d27 = guideInfo.getValue();
        Color color = this.getSettings().getColor("bottomColor");
        Color color2 = this.getSettings().getColor("neutralColor");
        Color color3 = this.getSettings().getColor("topColor");
        dataSeries.setBarColor(n2, (Object)TechnicalRank$Values.TR, color);
        if (d26 > d27 * 0.5) {
            dataSeries.setBarColor(n2, (Object)TechnicalRank$Values.TR, color2);
        }
        if (d26 > d27) {
            dataSeries.setBarColor(n2, (Object)TechnicalRank$Values.TR, color3);
        }
        dataSeries.setComplete(n2);
    }
}

