/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.SignalToNoiseRatio$Values;

@StudyHeader(namespace="com.motivewave", id="ID_SIGNAL_NOISE_RATIO", rb="com.motivewave.platform.study.nls.strings2", label="LBL_STNR", name="NAME_SIGNAL_TO_NOISE_RATIO", desc="DESC_STNR", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/signal_to_noise_ratio.htm", signals=false, overlay=false, studyOverlay=true)
public class SignalToNoiseRatio
extends Study {
    static final double a = 0.635;
    static final double b = 0.338;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("HILBERT_TRANSFORM_PERIOD", new Object[0]), 7, 7, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("AMPLITUDE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 6.0, -999.01, 999.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SignalToNoiseRatio$Values.INPHASE, this.get("INPHASE", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)SignalToNoiseRatio$Values.AMP, "line");
        runtimeDescriptor.declareIndicator((Object)SignalToNoiseRatio$Values.AMP, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{SignalToNoiseRatio$Values.AMP});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - n3, object, 0.0);
        double d5 = d3 - d4;
        double d6 = dataSeries.getHigh(n2);
        double d7 = dataSeries.getLow(n2);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)SignalToNoiseRatio$Values.RANGE, 0.0);
        double d9 = 0.2 * (d6 - d7) + 0.8 * d8;
        dataSeries.setDouble(n2, (Object)SignalToNoiseRatio$Values.RANGE, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)SignalToNoiseRatio$Values.V1, Double.valueOf(d5));
        if (n2 < n3 + 4) {
            return;
        }
        double d10 = dataSeries.getDouble(n2 - 2, (Object)SignalToNoiseRatio$Values.V1, 0.0);
        double d11 = dataSeries.getDouble(n2 - 4, (Object)SignalToNoiseRatio$Values.V1, 0.0);
        double d12 = dataSeries.getDouble(n2 - 3, (Object)SignalToNoiseRatio$Values.INPHASE, 0.0);
        double d13 = dataSeries.getDouble(n2 - 2, (Object)SignalToNoiseRatio$Values.QUAD, 0.0);
        double d14 = 1.25 * (d11 - 0.635 * d10 + 0.635 * d12);
        double d15 = d10 - 0.338 * d5 + 0.338 * d13;
        dataSeries.setDouble(n2, (Object)SignalToNoiseRatio$Values.INPHASE, Double.valueOf(d14));
        dataSeries.setDouble(n2, (Object)SignalToNoiseRatio$Values.QUAD, Double.valueOf(d15));
        double d16 = dataSeries.getDouble(n2 - 1, (Object)SignalToNoiseRatio$Values.V2, 0.0);
        double d17 = 0.2 * (d14 * d14 + d15 * d15) + 0.8 * d16;
        dataSeries.setDouble(n2, (Object)SignalToNoiseRatio$Values.V2, Double.valueOf(d17));
        double d18 = dataSeries.getDouble(n2 - 1, (Object)SignalToNoiseRatio$Values.AMP, 0.0);
        if (d17 < 0.001) {
            d17 = 0.001;
        }
        if (d9 > 0.0) {
            d2 = 0.25 * (10.0 * Math.log(d17 / (d9 * d9)) / Math.log(10.0) + 1.9) + 0.75 * d18;
        }
        dataSeries.setDouble(n2, (Object)SignalToNoiseRatio$Values.AMP, Double.valueOf(d2));
        dataSeries.setComplete(n2);
    }
}

