/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.RsiDivergence$Signals;
import com.motivewave.platform.study.general2.RsiDivergence$Values;
import java.awt.Color;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_RSI_DIVERGENCE", rb="com.motivewave.platform.study.nls.strings2", name="NAME_RSI_DIVERGENCE", label="LBL_RSIDIV", desc="DESC_RSIDIV", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/rsi_divergence.htm", signals=true, overlay=false, requiresVolume=false, studyOverlay=true)
public class RsiDivergence
extends Study {
    static final String a = "Bears";
    static final String b = "Bulls";
    static final String c = "UseMethod";
    static final String d = "Neutral";
    static final String e = "NeutralOn";
    static final String[] a = new String[]{"Close", "High-Low", "Open", "Midpoint", "Typical", "Weighted"};

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("RSI_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("RSI_PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("RSI_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("TREND_INPUT", new Object[0]), (Object[])a, (Object)a[0])});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("TREND_PERIOD", new Object[0]), 4, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("USE_TREND_METHOD", new Object[0]), Boolean.valueOf(false))});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("TREND_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(e, this.get("NEUTRAL_COLOR_ON", new Object[0]), Boolean.valueOf(true))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(a, this.get("BEARISH_DIVERGENCE", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b, this.get("BULLISH_DIVERGENCE", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(d, this.get("NEUTRAL_BAR_COLOR", new Object[0]), defaults.getGrey())});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(c, new String[]{"method2"}));
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "method", "input2", "period2", c, "method2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiDivergence$Values.RSI, this.get("LBL_RSIDIV", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiDivergence$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RsiDivergence$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)RsiDivergence$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RsiDivergence$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)RsiDivergence$Values.RSI, "line");
        runtimeDescriptor.declareIndicator((Object)RsiDivergence$Values.RSI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{RsiDivergence$Values.RSI});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3) * 3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        boolean bl2;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        String string2 = (String)this.getSettings().getInput("input2", (Object)a[0]);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        boolean bl3 = this.getSettings().getBoolean(c);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2", Enums.MAMethod.SMA);
        boolean bl4 = this.getSettings().getBoolean(e);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d8 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d9 = guideInfo2.getValue();
        Enums.BarInput barInput = null;
        Enums.BarInput barInput2 = Enums.BarInput.LOW;
        if (string2 == "Close") {
            barInput = Enums.BarInput.CLOSE;
        }
        if (string2 == "High-Low") {
            barInput = Enums.BarInput.HIGH;
        }
        if (string2 == "Open") {
            barInput = Enums.BarInput.OPEN;
        }
        if (string2 == "Midpoint") {
            barInput = Enums.BarInput.MIDPOINT;
        }
        if (string2 == "Typical") {
            barInput = Enums.BarInput.TP;
        }
        if (string2 == "Weighted") {
            barInput = Enums.BarInput.WP;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d10 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d11 = 0.0;
        double d12 = 0.0;
        if (d10 > 0.0) {
            d11 = d10;
        } else {
            d12 = d10;
        }
        dataSeries.setDouble(n2, (Object)RsiDivergence$Values.UP, Double.valueOf(d11));
        dataSeries.setDouble(n2, (Object)RsiDivergence$Values.DOWN, Double.valueOf(Math.abs(d12)));
        if (n2 < Math.max(n3, n4) + 1) {
            return;
        }
        Double d13 = dataSeries.ma(mAMethod, n2, n3, (Object)RsiDivergence$Values.UP);
        if (d13 == null) {
            return;
        }
        Double d14 = dataSeries.ma(mAMethod, n2, n3, (Object)RsiDivergence$Values.DOWN);
        if (d14 == null) {
            return;
        }
        double d15 = d13 / d14;
        double d16 = 100.0 - 100.0 / (1.0 + d15);
        dataSeries.setDouble(n2, (Object)RsiDivergence$Values.RSI, Double.valueOf(d16));
        if (bl3) {
            Double d17 = dataSeries.ma(mAMethod2, n2, n4, (Object)barInput);
            if (d17 == null) {
                return;
            }
            Double d18 = dataSeries.ma(mAMethod2, n2, n4, (Object)barInput2);
            if (d18 == null) {
                return;
            }
            dataSeries.setDouble(n2, (Object)RsiDivergence$Values.MA1, d17);
            dataSeries.setDouble(n2, (Object)RsiDivergence$Values.MA2, d18);
        }
        if (n2 < Math.max(n3, n4) + n4 + 1) {
            return;
        }
        if (bl3) {
            d2 = dataSeries.getDouble(n2, (Object)RsiDivergence$Values.MA1, 0.0);
            d3 = dataSeries.getDouble(n2 - n4, (Object)RsiDivergence$Values.MA1, 0.0);
        } else {
            d2 = dataSeries.getDouble(n2, (Object)barInput, 0.0);
            d3 = dataSeries.getDouble(n2 - n4, (Object)barInput, 0.0);
        }
        double d19 = dataSeries.getDouble(n2 - n4, (Object)RsiDivergence$Values.RSI, d16);
        boolean bl5 = d2 > d3 && d16 < d19 && d16 >= d8;
        boolean bl6 = bl2 = d2 < d3 && d16 > d19 && d16 <= d9;
        if (string2 == "High-Low") {
            d6 = d2;
            d7 = d3;
            if (bl3) {
                d4 = dataSeries.getDouble(n2, (Object)RsiDivergence$Values.MA2, 0.0);
                d5 = dataSeries.getDouble(n2 - n4, (Object)RsiDivergence$Values.MA2, 0.0);
            } else {
                d4 = dataSeries.getDouble(n2, (Object)barInput2, 0.0);
                d5 = dataSeries.getDouble(n2 - n4, (Object)barInput2, 0.0);
            }
            bl5 = d6 > d7 && d16 < d19 && d16 >= d8;
            bl2 = d4 < d5 && d16 > d19 && d16 <= d9;
        }
        Color color = this.getSettings().getColor(a);
        Color color2 = this.getSettings().getColor(b);
        Color color3 = this.getSettings().getColor(d);
        if (bl4) {
            dataSeries.setPriceBarColor(n2, color3);
        }
        if (bl5) {
            dataSeries.setPriceBarColor(n2, color);
        }
        if (bl2) {
            dataSeries.setPriceBarColor(n2, color2);
        }
        boolean bl7 = bl5;
        boolean bl8 = bl2;
        dataSeries.setBoolean(n2, (Object)RsiDivergence$Signals.BUY, Boolean.valueOf(bl8));
        dataSeries.setBoolean(n2, (Object)RsiDivergence$Signals.SELL, Boolean.valueOf(bl7));
        if (bl7) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d16);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_RSI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d16, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RsiDivergence$Signals.SELL, string, (Object)d2);
        }
        if (bl8) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d16);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_RSI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d16, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RsiDivergence$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

