/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.InverseFisherTrans$Signals;
import com.motivewave.platform.study.general2.InverseFisherTrans$Values;

@StudyHeader(namespace="com.motivewave", id="ID_IFISH", rb="com.motivewave.platform.study.nls.strings2", name="NAME_INVERSE_FISHER_TRANSFORM", label="LBL_IFISH", desc="DESC_IFISH", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/inverse_fisher_transform.htm", signals=true, overlay=false, studyOverlay=true)
public class InverseFisherTrans
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("RSI_PERIOD", new Object[0]), 5, 10, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("RSI_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("AVERAGE_PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("AVERAGE_METHOD", new Object[0]), Enums.MAMethod.WMA)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_IFISH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.5, 0.0, 9.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.01, 9.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.5, -9.01, 0.0, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "method2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InverseFisherTrans$Values.IFISH, this.get("LBL_IFISH", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InverseFisherTrans$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InverseFisherTrans$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)InverseFisherTrans$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)InverseFisherTrans$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)InverseFisherTrans$Values.IFISH, "line");
        runtimeDescriptor.declareIndicator((Object)InverseFisherTrans$Values.IFISH, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{InverseFisherTrans$Values.IFISH});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d4 = 0.0;
        double d5 = 0.0;
        if (d3 > 0.0) {
            d4 = d3;
        } else {
            d5 = d3;
        }
        dataSeries.setDouble(n2, (Object)InverseFisherTrans$Values.UP, Double.valueOf(d4));
        dataSeries.setDouble(n2, (Object)InverseFisherTrans$Values.DOWN, Double.valueOf(Math.abs(d5)));
        if (n2 < n3 + 1) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)InverseFisherTrans$Values.UP);
        if (d6 == null) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)InverseFisherTrans$Values.DOWN);
        if (d7 == null) {
            return;
        }
        double d8 = d6 / d7;
        double d9 = 100.0 - 100.0 / (1.0 + d8);
        double d10 = 0.1 * (d9 - 50.0);
        dataSeries.setDouble(n2, (Object)InverseFisherTrans$Values.VALUE1, Double.valueOf(d10));
        if (n2 < n3 + n4 + 1) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod2, n2, n4, (Object)InverseFisherTrans$Values.VALUE1);
        if (d11 == null) {
            return;
        }
        double d12 = (Math.exp(2.0 * d11) - 1.0) / (Math.exp(2.0 * d11) + 1.0);
        dataSeries.setDouble(n2, (Object)InverseFisherTrans$Values.IFISH, Double.valueOf(d12));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        double d15 = dataSeries.getDouble(n2 - 1, (Object)InverseFisherTrans$Values.IFISH, 0.0);
        boolean bl2 = d12 > d13 && d15 > d12 && d12 > this.a;
        boolean bl3 = d12 < d14 && d15 < d12 && d12 < this.b;
        dataSeries.setBoolean(n2, (Object)InverseFisherTrans$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)InverseFisherTrans$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_INVERSE_FISHER_TRANSFORM_PRICE_IFISH", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)InverseFisherTrans$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_INVERSE_FISHER_TRANSFORM_PRICE_IFISH", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)InverseFisherTrans$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

