/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.InverseFisherCyberCycle$Signals;
import com.motivewave.platform.study.general2.InverseFisherCyberCycle$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_IFISHCC", rb="com.motivewave.platform.study.nls.strings2", name="NAME_INVERSE_FISHER_CYBER_CYCLE", label="LBL_IFISHCC", desc="DESC_IFISHCC", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/inverse_fisher_cyber_cycle.htm", signals=true, overlay=false, studyOverlay=true)
public class InverseFisherCyberCycle
extends Study {
    static final String a = "Alpha";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("ALPHA", new Object[0]), 0.07, 0.0, 1.001, 0.001)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_IFISHCC", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 1.0, 0.0, 9999.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.01, 999.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -1.0, -9999.01, 0.0, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InverseFisherCyberCycle$Values.ICYCLE, this.get("LBL_IFISHCC", new Object[0]), new String[]{"input", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InverseFisherCyberCycle$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)InverseFisherCyberCycle$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)InverseFisherCyberCycle$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)InverseFisherCyberCycle$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)InverseFisherCyberCycle$Values.ICYCLE, "line");
        runtimeDescriptor.declareIndicator((Object)InverseFisherCyberCycle$Values.ICYCLE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{InverseFisherCyberCycle$Values.ICYCLE});
        this.setRuntimeDescriptor(runtimeDescriptor);
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = 0.0;
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d6 = dataSeries.getDouble(n2 - 2, object, 0.0);
        double d7 = dataSeries.getDouble(n2 - 3, object, 0.0);
        double d8 = (d4 + 2.0 * d5 + 2.0 * d6 + d7) / 6.0;
        dataSeries.setDouble(n2, (Object)InverseFisherCyberCycle$Values.SMTH, Double.valueOf(d8));
        if (n2 < 5) {
            d3 = (d4 - 2.0 * d5 + d6) / 4.0;
            dataSeries.setDouble(n2, (Object)InverseFisherCyberCycle$Values.CYCLE, Double.valueOf(d3));
            return;
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)InverseFisherCyberCycle$Values.SMTH, 0.0);
        double d10 = dataSeries.getDouble(n2 - 2, (Object)InverseFisherCyberCycle$Values.SMTH, 0.0);
        double d11 = dataSeries.getDouble(n2 - 1, (Object)InverseFisherCyberCycle$Values.CYCLE, 0.0);
        double d12 = dataSeries.getDouble(n2 - 2, (Object)InverseFisherCyberCycle$Values.CYCLE, 0.0);
        d3 = (1.0 - 0.5 * d2) * (1.0 - 0.5 * d2) * (d8 - 2.0 * d9 + d10) + 2.0 * (1.0 - d2) * d11 - (1.0 - d2) * (1.0 - d2) * d12;
        dataSeries.setDouble(n2, (Object)InverseFisherCyberCycle$Values.CYCLE, Double.valueOf(d3));
        double d13 = 100.0 * (Math.exp(2.0 * d3) - 1.0) / (Math.exp(2.0 * d3) + 1.0);
        dataSeries.setDouble(n2, (Object)InverseFisherCyberCycle$Values.ICYCLE, Double.valueOf(d13));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d14 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d15 = guideInfo2.getValue();
        double d16 = dataSeries.getDouble(n2 - 1, (Object)InverseFisherCyberCycle$Values.ICYCLE, 0.0);
        boolean bl2 = d13 > d14 && d16 > d13 && d13 > this.a;
        boolean bl3 = d13 < d15 && d16 < d13 && d13 < this.b;
        dataSeries.setBoolean(n2, (Object)InverseFisherCyberCycle$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)InverseFisherCyberCycle$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d13;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d13);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_INVERSE_FISHER_CYBER_PRICE_ICYCLE", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d13, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)InverseFisherCyberCycle$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d13;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d13);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_INVERSE_FISHER_CYBER_PRICE_ICYCLE", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d13, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)InverseFisherCyberCycle$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

