/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.ICyclePeriod$Values;

@StudyHeader(namespace="com.motivewave", id="ID_ICYCLE_PERIOD", rb="com.motivewave.platform.study.nls.strings2", label="LBL_ICPM", name="NAME_INSTANTANEOUS_CYCLE_PERIOD_MEASURMENT", desc="DESC_ICPM", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/instantaneous_cycle_period_measurment.htm", signals=false, overlay=false, studyOverlay=true)
public class ICyclePeriod
extends Study {
    static final double a = 0.635;
    static final double b = 0.338;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("HILBERT_TRANSFORM_PERIOD", new Object[0]), 7, 7, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("CYCLE_PERIOD", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 999.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ICyclePeriod$Values.PERIOD, this.get("HILBERT_TRANSFORM_PERIOD", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)ICyclePeriod$Values.PERIOD, "line");
        runtimeDescriptor.declareIndicator((Object)ICyclePeriod$Values.PERIOD, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ICyclePeriod$Values.PERIOD});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 56);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - n3, object, 0.0);
        double d5 = d3 - d4;
        dataSeries.setDouble(n2, (Object)ICyclePeriod$Values.V1, Double.valueOf(d5));
        if (n2 < n3 + 4) {
            return;
        }
        double d6 = dataSeries.getDouble(n2 - 2, (Object)ICyclePeriod$Values.V1, 0.0);
        double d7 = dataSeries.getDouble(n2 - 4, (Object)ICyclePeriod$Values.V1, 0.0);
        double d8 = dataSeries.getDouble(n2 - 3, (Object)ICyclePeriod$Values.INPHASE, 0.0);
        double d9 = dataSeries.getDouble(n2 - 2, (Object)ICyclePeriod$Values.QUAD, 0.0);
        double d10 = 1.25 * (d7 - 0.635 * d6 + 0.635 * d8);
        double d11 = d6 - 0.338 * d5 + 0.338 * d9;
        dataSeries.setDouble(n2, (Object)ICyclePeriod$Values.INPHASE, Double.valueOf(d10));
        dataSeries.setDouble(n2, (Object)ICyclePeriod$Values.QUAD, Double.valueOf(d11));
        if (n2 < n3 + 5) {
            return;
        }
        double d12 = dataSeries.getDouble(n2 - 1, (Object)ICyclePeriod$Values.INPHASE, 0.0);
        double d13 = dataSeries.getDouble(n2 - 1, (Object)ICyclePeriod$Values.QUAD, 0.0);
        if (Math.abs(d10 + d12) > 0.0) {
            d2 = Math.atan(Math.abs((d11 + d13) / (d10 + d12)));
        }
        if (d10 < 0.0 && d11 > 0.0) {
            d2 = 180.0 - d2;
        }
        if (d10 < 0.0 && d11 < 0.0) {
            d2 = 180.0 + d2;
        }
        if (d10 > 0.0 && d11 < 0.0) {
            d2 = 360.0 - d2;
        }
        dataSeries.setDouble(n2, (Object)ICyclePeriod$Values.PHASE, Double.valueOf(d2));
        if (n2 < n3 + 6) {
            return;
        }
        double d14 = dataSeries.getDouble(n2 - 1, (Object)ICyclePeriod$Values.PHASE, 0.0);
        double d15 = d14 - d2;
        if (d14 < 90.0 && d2 > 270.0) {
            d15 = 360.0 + d14 - d2;
        }
        if (d15 < 1.0) {
            d15 = 1.0;
        }
        if (d15 > 60.0) {
            d15 = 60.0;
        }
        dataSeries.setDouble(n2, (Object)ICyclePeriod$Values.DELTAPHASE, Double.valueOf(d15));
        if (n2 < n3 + 55) {
            return;
        }
        int n4 = 0;
        double d16 = 0.0;
        double d17 = 0.0;
        for (int i2 = 0; i2 <= 50; ++i2) {
            d17 = dataSeries.getDouble(n2 - i2, (Object)ICyclePeriod$Values.DELTAPHASE, 0.0);
            if (!((d16 += d17) > 360.0) || n4 != 0) continue;
            n4 = i2;
        }
        dataSeries.setInt(n2, (Object)ICyclePeriod$Values.INSTPERIOD, n4);
        if (n2 < n3 + 56) {
            return;
        }
        if (n4 == 0) {
            n4 = dataSeries.getInt(n2 - 1, (Object)ICyclePeriod$Values.INSTPERIOD);
        }
        double d18 = dataSeries.getDouble(n2 - 1, (Object)ICyclePeriod$Values.PERIOD, 0.0);
        double d19 = 0.25 * (double)n4 + 0.75 * d18;
        dataSeries.setDouble(n2, (Object)ICyclePeriod$Values.PERIOD, Double.valueOf(d19));
        dataSeries.setComplete(n2);
    }
}

