/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.HeikinAshiCOLT$Signals;
import com.motivewave.platform.study.general2.HeikinAshiCOLT$Values;

@StudyHeader(namespace="com.motivewave", id="ID_HACOLT", rb="com.motivewave.platform.study.nls.strings2", label="LBL_HACOLT", name="NAME_HEIKIN_ASHI_CANDLES_OSCILLATOR_LT", desc="DESC_HACOLT", helpLink="http://www.motivewave.com/studies/heikin_ashi_candles_oscillator_lt.htm", signals=true, overlay=false, studyOverlay=true)
public class HeikinAshiCOLT
extends Study {
    static final String a = "Candle";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.WP)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD1", new Object[0]), Enums.MAMethod.TEMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("TEMA_PERIOD", new Object[0]), 55, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("METHOD2", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("EMA_PERIOD", new Object[0]), 60, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("CANDLE_SIZE_FACTOR", new Object[0]), 1.1, 0.01, 5.0, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 100.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getLineColor());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 0.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getLineColor());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "method2", "period2", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HeikinAshiCOLT$Values.HACOLT, this.get("LBL_HACOLT", new Object[0]), new String[]{"input", "method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HeikinAshiCOLT$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HeikinAshiCOLT$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)HeikinAshiCOLT$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)HeikinAshiCOLT$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)HeikinAshiCOLT$Values.HACOLT, "line");
        runtimeDescriptor.declareIndicator((Object)HeikinAshiCOLT$Values.HACOLT, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{HeikinAshiCOLT$Values.HACOLT});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = n2 * 9 + n3 * 2 + 1;
        this.setMinBars(n4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.WP);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2");
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.OPEN, 0.0);
        double d4 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.HIGH, 0.0);
        double d6 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d7 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.LOW, 0.0);
        double d8 = dataSeries.getDouble(n2, (Object)Enums.BarInput.CLOSE, 0.0);
        double d9 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.CLOSE, 0.0);
        double d10 = dataSeries.getDouble(n2, object, 0.0);
        double d11 = dataSeries.getDouble(n2 - 1, object);
        double d12 = dataSeries.getDouble(n2 - 1, (Object)HeikinAshiCOLT$Values.HAOP, d3);
        double d13 = (d11 + d12) / 2.0;
        dataSeries.setDouble(n2, (Object)HeikinAshiCOLT$Values.HAOP, Double.valueOf(d13));
        double d14 = Math.max(d4, Math.max(d13, d10));
        double d15 = Math.min(d6, Math.min(d13, d10));
        double d16 = (d10 + d13 + d14 + d15) / 4.0;
        dataSeries.setDouble(n2, (Object)HeikinAshiCOLT$Values.HACL, Double.valueOf(d16));
        Double d17 = dataSeries.ma(mAMethod, n2, n3, (Object)Enums.BarInput.TP);
        dataSeries.setDouble(n2, (Object)HeikinAshiCOLT$Values.TPT1, d17);
        Double d18 = dataSeries.ma(mAMethod, n2, n3, (Object)HeikinAshiCOLT$Values.HACL);
        dataSeries.setDouble(n2, (Object)HeikinAshiCOLT$Values.HAT1, d18);
        Double d19 = dataSeries.ma(mAMethod, n2, n3, (Object)HeikinAshiCOLT$Values.TPT1);
        Double d20 = dataSeries.ma(mAMethod, n2, n3, (Object)HeikinAshiCOLT$Values.HAT1);
        if (d20 == null || d18 == null || d19 == null) {
            return;
        }
        double d21 = d18 - d20;
        double d22 = d18 - d21;
        double d23 = d17 - d19;
        double d24 = d17 - d23;
        double d25 = dataSeries.getDouble(n2 - 1, (Object)HeikinAshiCOLT$Values.HACL, d8);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (d16 >= d13 || d25 >= d12 || d8 >= d16) {
            bl2 = true;
        }
        if (!(d16 >= d13 || d25 >= d12 || d8 >= d16 || !(d4 > d5) && !(d6 > d7))) {
            bl2 = true;
        }
        bl3 = d22 - d24 >= 0.0;
        bl4 = Math.abs(d8 - d3) < (d4 - d6) * d2 && d4 >= d7;
        bl5 = bl2 || bl3;
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.KEEPING, Boolean.valueOf(bl5));
        Boolean bl6 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.KEEPING);
        if (bl6 == null) {
            return;
        }
        boolean bl7 = bl5 || bl6 != false && (d8 >= d3 || bl4);
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.KEEPALL, Boolean.valueOf(bl7));
        Boolean bl8 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.KEEPALL);
        if (bl8 == null) {
            return;
        }
        boolean bl9 = bl7 || bl8 != false && bl4;
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.UTR, Boolean.valueOf(bl9));
        Boolean bl10 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.UTR);
        if (bl10 == null) {
            return;
        }
        boolean bl11 = d16 < d13 || d25 < d12;
        boolean bl12 = d24 - d22 < 0.0;
        boolean bl13 = Math.abs(d8 - d3) < (d4 - d6) * d2 && d6 < d5;
        boolean bl14 = bl11 || bl12;
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.KEEPING2, Boolean.valueOf(bl14));
        Boolean bl15 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.KEEPING2);
        if (bl15 == null) {
            return;
        }
        boolean bl16 = bl14 || bl15 != false && (d8 < d3 || d8 < d9);
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.KEEPALL2, Boolean.valueOf(bl16));
        Boolean bl17 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.KEEPALL2);
        if (bl17 == null) {
            return;
        }
        boolean bl18 = bl16 || bl17 != false && bl13;
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.DTR, Boolean.valueOf(bl18));
        Boolean bl19 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.DTR);
        if (bl19 == null) {
            return;
        }
        boolean bl20 = !bl18 && bl19 != false && bl9;
        boolean bl21 = !bl9 && bl10 != false && bl18;
        Boolean bl22 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.RESULT, false);
        boolean bl23 = false;
        if (bl20) {
            bl23 = true;
        }
        if (!bl20 && bl21) {
            bl23 = false;
        }
        if (!bl20 && !bl21) {
            bl23 = bl22;
        }
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.RESULT, Boolean.valueOf(bl23));
        Double d26 = dataSeries.ma(mAMethod2, n2, n4, (Object)Enums.BarInput.CLOSE);
        boolean bl24 = d8 < d26;
        Boolean bl25 = dataSeries.getBoolean(n2 - 1, (Object)HeikinAshiCOLT$Values.LTRESULT, false);
        boolean bl26 = false;
        if (bl23) {
            bl26 = true;
        }
        if (!bl23 && bl24) {
            bl26 = false;
        }
        if (!bl23 && !bl24) {
            bl26 = bl25;
        }
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Values.LTRESULT, Boolean.valueOf(bl26));
        double d27 = dataSeries.getDouble(n2 - 1, (Object)HeikinAshiCOLT$Values.HACOLT, 0.0);
        double d28 = 0.0;
        if (bl23) {
            d28 = 100.0;
        }
        if (!bl23 && bl26) {
            d28 = 50.0;
        }
        if (!bl23 && !bl26) {
            d28 = 0.0;
        }
        dataSeries.setDouble(n2, (Object)HeikinAshiCOLT$Values.HACOLT, Double.valueOf(d28));
        boolean bl27 = d27 != 50.0 && d28 == 50.0 || d27 != 0.0 && d28 == 0.0;
        boolean bl28 = d27 != 100.0 && d28 == 100.0;
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Signals.SELL, Boolean.valueOf(bl27));
        dataSeries.setBoolean(n2, (Object)HeikinAshiCOLT$Signals.BUY, Boolean.valueOf(bl28));
        if (bl27) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d28);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_CLOSE_HACOLT", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d28, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)HeikinAshiCOLT$Signals.SELL, string, (Object)d8);
        }
        if (bl28) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d28);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_CLOSE_HACOLT", new Object[]{Util.round((double)d8, (int)2), Util.round((double)d28, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)HeikinAshiCOLT$Signals.BUY, string, (Object)d8);
        }
        dataSeries.setComplete(n2);
    }
}

