/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.FishTranStochOsc$Signals;
import com.motivewave.platform.study.general2.FishTranStochOsc$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_FISH_TRANS_STOCH_OSC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_FTSO", name="NAME_FISHER_TRANSFORM_STOCHASTIC_OSCILLATOR", desc="DESC_FISH_TRANS_STOCH_OSC", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/fisher_transform_stochastic_oscillator.htm", signals=true, overlay=false, studyOverlay=true)
public class FishTranStochOsc
extends Study {
    static final String a = "HighLow";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.WMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("AVERAGE_PERIOD", new Object[0]), 2, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("STOCHASTIC_PERIOD", new Object[0]), 30, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SMOOTH_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("FTSO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("RBWS", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("DS", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SDS", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 80.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 20.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FishTranStochOsc$Values.FTSO, this.get("LBL_FTS", new Object[0]), new String[]{"input", "method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FishTranStochOsc$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FishTranStochOsc$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)FishTranStochOsc$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)FishTranStochOsc$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)FishTranStochOsc$Values.FTSO, "line");
        runtimeDescriptor.declarePath((Object)FishTranStochOsc$Values.RBWS, "line2");
        runtimeDescriptor.declareIndicator((Object)FishTranStochOsc$Values.FTSO, "ind");
        runtimeDescriptor.declareIndicator((Object)FishTranStochOsc$Values.RBWS, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{FishTranStochOsc$Values.FTSO, FishTranStochOsc$Values.RBWS});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 * 10 + n3 + n4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d2 == null) {
            return;
        }
        double d3 = d2 * 5.0;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA1, d2);
        if (n2 < n3 * 2) {
            return;
        }
        Double d4 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA1);
        if (d4 == null) {
            return;
        }
        d3 += d4 * 4.0;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA2, d4);
        if (n2 < n3 * 3) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA2);
        if (d5 == null) {
            return;
        }
        d3 += d5 * 3.0;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA3, d4);
        if (n2 < n3 * 4) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA3);
        if (d6 == null) {
            return;
        }
        d3 += d6 * 2.0;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA4, d6);
        if (n2 < n3 * 5) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA4);
        if (d7 == null) {
            return;
        }
        d3 += d7.doubleValue();
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA5, d7);
        if (n2 < n3 * 6) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA5);
        if (d8 == null) {
            return;
        }
        d3 += d8.doubleValue();
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA6, d8);
        if (n2 < n3 * 7) {
            return;
        }
        Double d9 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA6);
        if (d9 == null) {
            return;
        }
        d3 += d9.doubleValue();
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA7, d9);
        if (n2 < n3 * 8) {
            return;
        }
        Double d10 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA7);
        if (d10 == null) {
            return;
        }
        d3 += d10.doubleValue();
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA8, d10);
        if (n2 < n3 * 9) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA8);
        if (d11 == null) {
            return;
        }
        d3 += d11.doubleValue();
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.MA9, d11);
        if (n2 < n3 * 10) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n3, (Object)FishTranStochOsc$Values.MA9);
        if (d12 == null) {
            return;
        }
        d3 = (d3 + d12) / 20.0;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.RBW, Double.valueOf(d3));
        if (n2 < n3 * 10 + n4) {
            return;
        }
        double d13 = dataSeries.lowest(n2, n4, (Object)FishTranStochOsc$Values.RBW);
        double d14 = dataSeries.highest(n2, n4, (Object)FishTranStochOsc$Values.RBW);
        double d15 = d3 - d13;
        double d16 = d14 - d13;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.NUM, Double.valueOf(d15));
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.DEN, Double.valueOf(d16));
        if (n2 < n3 * 10 + n4 + n5) {
            return;
        }
        d15 = dataSeries.sum(n2, n5, (Object)FishTranStochOsc$Values.NUM);
        d16 = dataSeries.sum(n2, n5, (Object)FishTranStochOsc$Values.DEN);
        double d17 = d15 / (d16 + 1.0E-4) * 100.0;
        double d18 = 0.1 * (d17 - 50.0);
        double d19 = ((Math.exp(2.0 * d18) - 1.0) / (Math.exp(2.0 * d18) + 1.0) + 1.0) * 50.0;
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.RBWS, Double.valueOf(d17));
        dataSeries.setDouble(n2, (Object)FishTranStochOsc$Values.FTSO, Double.valueOf(d19));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d20 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d21 = guideInfo2.getValue();
        double d22 = dataSeries.getDouble(n2, object, 0.0);
        double d23 = dataSeries.getDouble(n2 - 1, (Object)FishTranStochOsc$Values.FTSO, 0.0);
        boolean bl2 = d23 < d20 && d19 > d20;
        boolean bl3 = d23 > d21 && d19 < d21;
        dataSeries.setBoolean(n2, (Object)FishTranStochOsc$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)FishTranStochOsc$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d19);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_FTSO", new Object[]{Util.round((double)d22, (int)2), Util.round((double)d19, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)FishTranStochOsc$Signals.SELL, string, (Object)d22);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d19);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_FTSO", new Object[]{Util.round((double)d22, (int)2), Util.round((double)d19, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)FishTranStochOsc$Signals.BUY, string, (Object)d22);
        }
        dataSeries.setComplete(n2);
    }
}

