/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.EldersThermometer$Signals;
import com.motivewave.platform.study.general2.EldersThermometer$Values;
import java.awt.Color;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_ERTHER", rb="com.motivewave.platform.study.nls.strings2", label="LBL_ETHER", name="NAME_ELDERS_THERMOMETER", desc="DESC_ERTHER", menu="MENU_ALEXANDER_ELDER", helpLink="http://www.motivewave.com/studies/elders_thermometer.htm", signals=true, overlay=false, studyOverlay=true)
public class EldersThermometer
extends Study {
    static final String a = "BuyFac";
    static final String b = "SellFac";
    static final String c = "BuyMarker";
    static final String d = "SellMarker";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 22, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("SELL_FACTOR", new Object[0]), 2.0, 1.0, 9.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("BUY_FACTOR", new Object[0]), 0.5, 0.01, 1.0, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("BUY_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getBarColor())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("SELL_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA_PATH", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_ETHER", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.1, 9.1, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor(c, this.get("BUY_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor(d, this.get("SELL_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", b, a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EldersThermometer$Values.MA, this.get("LBL_ETHER", new Object[0]), new String[]{"method", "period", b, a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EldersThermometer$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EldersThermometer$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)EldersThermometer$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)EldersThermometer$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareBars((Object)EldersThermometer$Values.THER);
        runtimeDescriptor.declarePath((Object)EldersThermometer$Values.MA, "line2");
        runtimeDescriptor.declareIndicator((Object)EldersThermometer$Values.THER, "ind");
        runtimeDescriptor.declareIndicator((Object)EldersThermometer$Values.MA, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{EldersThermometer$Values.THER, EldersThermometer$Values.MA});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d2 = this.getSettings().getDouble(b);
        double d3 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d5 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.LOW, 0.0);
        double d7 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.HIGH, 0.0);
        double d8 = Math.abs(d6 - d4);
        double d9 = Math.abs(d5 - d7);
        double d10 = d8;
        if (d9 > d8) {
            d10 = d9;
        }
        dataSeries.setDouble(n2, (Object)EldersThermometer$Values.THER, Double.valueOf(d10));
        if (n2 < n3 + 1) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod, n2, n3, (Object)EldersThermometer$Values.THER);
        if (d11 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)EldersThermometer$Values.MA, d11);
        dataSeries.setComplete(n2);
        if (n2 < n3 + 2) {
            return;
        }
        boolean bl2 = d10 > d11 * d2;
        boolean bl3 = d10 < d11 * d3;
        dataSeries.setBoolean(n2, (Object)EldersThermometer$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)EldersThermometer$Signals.SELL, Boolean.valueOf(bl2));
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("neutralColor");
        Color color3 = this.getSettings().getColor("downColor");
        dataSeries.setBarColor(n2, (Object)EldersThermometer$Values.THER, color2);
        if (bl3) {
            dataSeries.setBarColor(n2, (Object)EldersThermometer$Values.THER, color);
        }
        if (bl2) {
            dataSeries.setBarColor(n2, (Object)EldersThermometer$Values.THER, color3);
        }
        if (bl2) {
            this.a = d10;
            this.b = Double.MAX_VALUE;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d10);
            markerInfo = this.getSettings().getMarker(d);
            string = this.get("SELL_HIGH_THER", new Object[]{Util.round((double)d5, (int)2), Util.round((double)d10, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)EldersThermometer$Signals.SELL, string, (Object)d5);
        }
        if (bl3) {
            this.b = d10;
            this.a = Double.NEGATIVE_INFINITY;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d10);
            markerInfo = this.getSettings().getMarker(c);
            string = this.get("BUY_LOW_THER", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d10, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)EldersThermometer$Signals.BUY, string, (Object)d4);
        }
    }
}

