/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.DecisionPointPMO$Signals;
import com.motivewave.platform.study.general2.DecisionPointPMO$Values;

@StudyHeader(namespace="com.motivewave", id="ID_DP_PMO", rb="com.motivewave.platform.study.nls.strings2", label="LBL_PMO", menu="MENU_GENERAL", name="NAME_DECISION_POINT_MOMENTUM_OSC", desc="DESC_PMO", signals=true, overlay=false, studyOverlay=true)
public class DecisionPointPMO
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FAST_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SLOW_PERIOD", new Object[0]), 35, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SIGNAL_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PMO_PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("PMO_IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL_PATH", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DecisionPointPMO$Values.PMO, this.get("LBL_PMO", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DecisionPointPMO$Values.SIG, this.get("SIG", new Object[0]), new String[]{"method", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DecisionPointPMO$Signals.CROSS_BELOW, Enums.ValueType.BOOLEAN, this.get("CROSS_BELOW", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DecisionPointPMO$Signals.CROSS_ABOVE, Enums.ValueType.BOOLEAN, this.get("CROSS_ABOVE", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)DecisionPointPMO$Signals.CROSS_BELOW, this.get("CROSS_BELOW", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DecisionPointPMO$Signals.CROSS_ABOVE, this.get("CROSS_ABOVE", new Object[0]));
        runtimeDescriptor.declarePath((Object)DecisionPointPMO$Values.PMO, "line");
        runtimeDescriptor.declarePath((Object)DecisionPointPMO$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)DecisionPointPMO$Values.PMO, "ind");
        runtimeDescriptor.declareIndicator((Object)DecisionPointPMO$Values.SIG, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{DecisionPointPMO$Values.PMO, DecisionPointPMO$Values.SIG});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3 + n4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        DataSeries dataSeries = dataContext.getDataSeries();
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d4 = d2 / d3 * 100.0 - 100.0;
        dataSeries.setDouble(n2, (Object)DecisionPointPMO$Values.TEMP1, Double.valueOf(d4));
        Double d5 = dataSeries.ma(mAMethod, n2, n4, (Object)DecisionPointPMO$Values.TEMP1);
        if (d5 == null) {
            return;
        }
        double d6 = 10.0 * d5;
        dataSeries.setDouble(n2, (Object)DecisionPointPMO$Values.TEMP2, Double.valueOf(d6));
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)DecisionPointPMO$Values.TEMP2);
        if (d7 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DecisionPointPMO$Values.PMO, d7);
        Double d8 = dataSeries.ma(mAMethod, n2, n5, (Object)DecisionPointPMO$Values.PMO);
        dataSeries.setDouble(n2, (Object)DecisionPointPMO$Values.SIG, d8);
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)DecisionPointPMO$Values.PMO, (Object)DecisionPointPMO$Values.SIG);
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)DecisionPointPMO$Values.PMO, (Object)DecisionPointPMO$Values.SIG);
        dataSeries.setBoolean(n2, (Object)DecisionPointPMO$Signals.CROSS_ABOVE, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DecisionPointPMO$Signals.CROSS_BELOW, Boolean.valueOf(bl2));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("CROSS_BELOW_PRICE_PMO", new Object[]{Util.round((double)d2, (int)4), Util.round((double)d7, (int)4)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DecisionPointPMO$Signals.CROSS_BELOW, string, (Object)d2);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("CROSS_ABOVE_PRICE_PMO", new Object[]{Util.round((double)d2, (int)4), Util.round((double)d7, (int)4)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DecisionPointPMO$Signals.CROSS_ABOVE, string, (Object)d2);
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

