/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.CenterOfGravity$Signals;
import com.motivewave.platform.study.general2.CenterOfGravity$Values;

@StudyHeader(namespace="com.motivewave", id="ID_COGVT", rb="com.motivewave.platform.study.nls.strings2", name="NAME_CENTER_OF_GRAVITY", label="LBL_COG", desc="DESC_COGVT", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/center_of_gravity.htm", signals=true, overlay=false, studyOverlay=true)
public class CenterOfGravity
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("COG_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SIGNAL_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_COG", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_COG", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 550.1, 0.0, 9999.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 550.0, 0.0, 9999.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 549.9, 0.0, 9999.01, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CenterOfGravity$Values.COGVT, this.get("LBL_COGVT", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CenterOfGravity$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CenterOfGravity$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)CenterOfGravity$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CenterOfGravity$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)CenterOfGravity$Values.COGVT, "line");
        runtimeDescriptor.declarePath((Object)CenterOfGravity$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)CenterOfGravity$Values.COGVT, "ind");
        runtimeDescriptor.declareIndicator((Object)CenterOfGravity$Values.SIG, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{CenterOfGravity$Values.COGVT, CenterOfGravity$Values.SIG});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d4 = dataSeries.getDouble(i2, object, 0.0);
            d2 += d4 * (double)(n4 + 1);
            d3 += d4;
            ++n4;
        }
        double d5 = 100.0 * d2 / d3;
        dataSeries.setDouble(n2, (Object)CenterOfGravity$Values.COGVT, Double.valueOf(d5));
        int n5 = this.getSettings().getInteger("period2");
        if (n2 < n3 + n5) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        Double d6 = dataSeries.ma(mAMethod, n2, n5, (Object)CenterOfGravity$Values.COGVT);
        dataSeries.setDouble(n2, (Object)CenterOfGravity$Values.SIG, d6);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d7 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d8 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)CenterOfGravity$Values.COGVT, (Object)CenterOfGravity$Values.SIG) && d5 > d7 && d5 > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)CenterOfGravity$Values.COGVT, (Object)CenterOfGravity$Values.SIG) && d5 < d8 && d5 < this.b;
        dataSeries.setBoolean(n2, (Object)CenterOfGravity$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)CenterOfGravity$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_COGVT", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)CenterOfGravity$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_COGVT", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)CenterOfGravity$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

