/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.AccumulativeSwingIndex$Values;

@StudyHeader(name="NAME_ACCUMULATIVE_SWING_INDEX", id="ID_ACC_SWING_IND", desc="DESC_ASI", namespace="com.motivewave", overlay=false, rb="com.motivewave.platform.study.nls.strings2", helpLink="http://www.investopedia.com/terms/a/asi.asp", label="LBL_ASI", studyOverlay=true, menu="MENU_GENERAL", signals=false)
public class AccumulativeSwingIndex
extends Study {
    static final String a = "LimitMove";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LIMIT_MOVE_FACTOR", new Object[0]), 1.0, 0.01, 99.999, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.setLabelSettings(new String[]{a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AccumulativeSwingIndex$Values.SI, this.get("LBL_ASI", new Object[0]), new String[]{a}));
        runtimeDescriptor.declarePath((Object)AccumulativeSwingIndex$Values.SI, "line");
        runtimeDescriptor.declareIndicator((Object)AccumulativeSwingIndex$Values.SI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{AccumulativeSwingIndex$Values.SI});
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 < 1) {
            return;
        }
        double d2 = this.getSettings().getDouble(a, 1.0);
        double d3 = dataSeries.getOpen(n2);
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getHigh(n2);
        double d6 = dataSeries.getClose(n2);
        double d7 = dataSeries.getOpen(n2 - 1);
        double d8 = dataSeries.getClose(n2 - 1);
        double d9 = Math.abs(d5 - d8);
        double d10 = Math.abs(d4 - d8);
        double d11 = Math.abs(d5 - d4);
        double d12 = Math.abs(d8 - d7);
        double d13 = Math.abs(d4 - d6);
        double d14 = Math.abs(d5 - d6);
        double d15 = Math.max(d9, d10);
        double d16 = 0.0;
        double d17 = dataSeries.getDouble(n2 - 1, (Object)AccumulativeSwingIndex$Values.SI, 0.0);
        if (d9 >= d10 && d9 >= d11) {
            d16 = d9 - 0.5 * d13 + 0.25 * d12;
        }
        if (d10 >= d9 && d10 >= d11) {
            d16 = d10 - 0.5 * d14 + 0.25 * d12;
        }
        if (d11 >= d9 && d11 >= d10) {
            d16 = d11 + 0.25 * d12;
        }
        double d18 = 50.0 * d15 / d2 * (d6 - d8 + 0.5 * (d6 - d3) + 0.25 * (d8 - d7)) / d16;
        dataSeries.setDouble(n2, (Object)AccumulativeSwingIndex$Values.SI, Double.valueOf(d18 += d17));
        dataSeries.setComplete(n2, n2 < dataSeries.size() - 1);
    }
}

