/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.ExitPoint;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.ExitPointDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.TifDescriptor;
import com.motivewave.platform.sdk.order_mgmt.Order;
import com.motivewave.platform.sdk.order_mgmt.OrderContext;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(id="TradeManager", namespace="com.motivewave", rb="com.motivewave.platform.study.nls.strings", name="TITLE_TRADE_MANAGER", desc="DESC_TRADE_MANAGER", menu="MENU_GENERAL", overlay=true, strategy=true, autoEntry=false, manualEntry=true, supportsStopPL=true, supportsUnrealizedPL=true, supportsRealizedPL=true, supportsTotalPL=true, supportsTargetPL=true, supportsRiskRatio=true, showTradeOptions=false, requiresBarUpdates=true)
public class l
extends Study {
    public static final String a = "tradeLots";
    public static final String b = "tif";
    public static final String c = "firstExit";
    public static final String d = "secondExit";
    public static final String e = "thirdExit";
    public static final String f = "breakEvenEnabled";
    public static final String g = "breakEvenPips";
    public static final String h = "coverPips";
    public static final String i = "maxLoss";
    public static final String j = "atrPeriod";
    public static final String k = "atrMultiplier";
    public static final String l = "atrEnabled";
    public static final long a = 2000L;
    private Order a;
    private Order b;
    private Order c;
    private Order d;
    private Order e;
    private Order f;
    private Order g;
    private Order h;
    private boolean a = false;
    private Order i;
    private Order j;
    private Order k;
    private boolean b = false;

    public void destroy() {
        super.destroy();
        this.a();
    }

    public void initialize(Defaults defaults) {
        super.initialize(defaults);
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        settingsDescriptor.addTab(this.a());
        settingsDescriptor.addTab(this.b());
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(f, new String[]{g, h, l, k, j}));
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(l, new String[]{k, j}));
        this.setSettingsDescriptor(settingsDescriptor);
    }

    protected SettingTab a() {
        SettingTab settingTab = new SettingTab(this.get("LBL_ENTRY_EXIT", new Object[0]));
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_ENTRY", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_TRADE_LOTS", new Object[0]), 3, 1, 99999, 1), new TifDescriptor(b, this.get("LBL_TIME_IN_FORCE", new Object[0]), Enums.TIF.GTC)});
        settingGroup = new SettingGroup(this.get("LBL_EXIT", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new ExitPointDescriptor(c, this.get("LBL_FIRST_EXIT", new Object[0]), 10, 1, true, false)});
        settingGroup.addRow(new SettingDescriptor[]{new ExitPointDescriptor(d, this.get("LBL_SECOND_EXIT", new Object[0]), 20, 1, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ExitPointDescriptor(e, this.get("LBL_THIRD_EXIT", new Object[0]), 30, 1, true, true)});
        return settingTab;
    }

    protected SettingTab b() {
        SettingTab settingTab = new SettingTab(this.get("LBL_STOP_LOSS", new Object[0]));
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_BREAK_EVEN", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(i, this.get("LBL_MAX_LOSS", new Object[0]), 10, 0, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(g, this.get("LBL_BREAK_EVEN_PIPS", new Object[0]), 6, 0, 999, 1), new IntegerDescriptor(h, this.get("LBL_COVER_PIPS", new Object[0]), 0, 0, 99, 1), new BooleanDescriptor(f, this.get("LBL_BREAK_EVEN_ENABLED", new Object[0]), Boolean.valueOf(true))});
        settingGroup = new SettingGroup(this.get("LBL_ATR_STOP", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(l, this.get("LBL_ATR_ENABLED", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(j, this.get("LBL_ATR_PERIOD", new Object[0]), 20, 1, 999, 1), new DoubleDescriptor(k, this.get("LBL_ATR_MULTIPLIER", new Object[0]), 2.5, 0.1, 999.0, 0.1)});
        return settingTab;
    }

    public void onActivate(OrderContext orderContext) {
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.b = false;
        this.setEntryState(Enums.EntryState.NONE);
    }

    public void onDeactivate(OrderContext orderContext) {
        this.b = false;
        this.a();
    }

    public void onReset(OrderContext orderContext) {
        orderContext.cancelOrders();
        super.onReset(orderContext);
        this.b = false;
        this.a();
    }

    public void onBarUpdate(OrderContext orderContext) {
        if (this.getEntryState() != Enums.EntryState.OPEN) {
            return;
        }
        Instrument instrument = orderContext.getInstrument();
        int n2 = this.getSettings().getInteger(g);
        if (this.isLong()) {
            if ((double)instrument.round(instrument.getSellPrice() - orderContext.getAvgEntryPrice()) >= instrument.round((double)n2 * instrument.getPointSize())) {
                this.a(orderContext);
            }
        } else if ((double)instrument.round(orderContext.getAvgEntryPrice() - instrument.getBuyPrice()) >= instrument.round((double)n2 * instrument.getPointSize())) {
            this.a(orderContext);
        }
    }

    public void onBarClose(OrderContext orderContext) {
        DataSeries dataSeries = orderContext.getDataContext().getDataSeries();
        switch (this.getEntryState()) {
            case NONE: 
            case PRE_ENTRY: {
                if (!(this.isLong() && dataSeries.getClose() > dataSeries.getOpen()) && (!this.isShort() || !(dataSeries.getClose() < dataSeries.getOpen()))) break;
                this.info("TradeManager::onBarClose() entering at market: " + orderContext.getInstrument().getSymbol());
                this.onEnterNow(orderContext);
                break;
            }
            case OPEN: {
                this.c(orderContext);
                break;
            }
        }
    }

    public void onOrderFilled(OrderContext orderContext, Order order) {
        boolean bl2 = this.getSettings().getExitPoint(e).isEnabled();
        boolean bl3 = this.getSettings().getExitPoint(d).isEnabled();
        if (order == this.a || bl2 && order == this.d || !bl2 && bl3 && order == this.c || !bl2 && !bl3 && order == this.b) {
            this.info("TradeManager::onOrderFilled() Entry Filled, creating exit orders " + orderContext.getInstrument().getSymbol());
            this.setEntryState(Enums.EntryState.OPEN);
            this.b(orderContext);
            this.a(order);
            return;
        }
        if (order == this.b || order == this.c) {
            return;
        }
        if (Util.in((Object)order, (Object[])new Object[]{this.e, this.f, this.g, this.h})) {
            this.b(orderContext, order);
        } else if (order == this.i) {
            this.d(orderContext);
        } else if (order == this.j) {
            this.e(orderContext);
        } else if (order == this.k) {
            this.f(orderContext);
        }
        this.a(order);
    }

    public void onOrderCancelled(OrderContext orderContext, Order order) {
        if (this.isCancelInProgress()) {
            return;
        }
        if (Util.in((Object)order, (Object[])new Object[]{this.a, this.b, this.c, this.d})) {
            orderContext.cancelOrders();
        }
        this.a(order);
    }

    public void onEnterNow(OrderContext orderContext) {
        if (this.getEntryState() != Enums.EntryState.NONE) {
            return;
        }
        this.setEntryState(Enums.EntryState.WAITING_ENTRY);
        Instrument instrument = orderContext.getInstrument();
        if (orderContext.supportsHedging() && this.getSettings().getExitPoint(d).isEnabled()) {
            ArrayList<Order> arrayList = new ArrayList<Order>();
            ExitPoint exitPoint = this.getSettings().getExitPoint(c);
            this.b = this.a(orderContext, this.isLong(), (float)exitPoint.getLots() * instrument.getDefaultQuantityAsFloat());
            arrayList.add(this.b);
            exitPoint = this.getSettings().getExitPoint(d);
            if (exitPoint.isEnabled()) {
                this.c = this.a(orderContext, this.isLong(), (float)exitPoint.getLots() * instrument.getDefaultQuantityAsFloat());
                arrayList.add(this.c);
            }
            if ((exitPoint = this.getSettings().getExitPoint(e)).isEnabled()) {
                this.d = this.a(orderContext, this.isLong(), (float)exitPoint.getLots() * instrument.getDefaultQuantityAsFloat());
                arrayList.add(this.d);
            }
            orderContext.submitOrders(arrayList);
        } else {
            this.a = this.a(orderContext, this.isLong(), (float)this.getSettings().getInteger(a).intValue() * instrument.getDefaultQuantityAsFloat());
            orderContext.submitOrders(new Order[]{this.a});
        }
    }

    public void onPositionClosed(OrderContext orderContext) {
        orderContext.cancelOrders();
        this.a();
        this.setState(Enums.StrategyState.INACTIVE);
    }

    private Order a(OrderContext orderContext, boolean bl2, float f2) {
        if (bl2) {
            return orderContext.createMarketOrder(Enums.OrderAction.BUY, f2);
        }
        return orderContext.createMarketOrder(Enums.OrderAction.SELL, f2);
    }

    private void a() {
        this.k = null;
        this.j = null;
        this.i = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.b();
    }

    private void b() {
        this.h = null;
        this.g = null;
        this.f = null;
        this.e = null;
    }

    private void a(OrderContext orderContext) {
        if (this.getEntryState() != Enums.EntryState.OPEN) {
            return;
        }
        if (!this.getSettings().getBoolean(f).booleanValue()) {
            return;
        }
        this.a = this.getSettings().getBoolean(l);
        this.a(orderContext, this.e);
        this.a(orderContext, this.f);
        this.a(orderContext, this.g);
        this.a(orderContext, this.h);
    }

    private void a(OrderContext orderContext, Order order) {
        boolean bl2;
        if (order == null || order.isFilled() || !order.exists()) {
            return;
        }
        float f2 = (float)(this.getSettings().getDouble(h) * (double)((float)orderContext.getInstrument().getPointSize()));
        float f3 = orderContext.getAvgEntryPrice();
        Instrument instrument = orderContext.getInstrument();
        if (f2 > 0.0f) {
            f3 = this.isLong() ? (f3 += f2) : (f3 -= f2);
        }
        if (bl2 = order.isBuy()) {
            float f4 = instrument.round(instrument.getAskPrice() + 2.0f * (float)instrument.getPointSize());
            if (f3 < f4) {
                this.warning("TradeManager::breakEvenTrail() too close to ask price setting 2 pts away: " + instrument.getSymbol() + " breakEven: " + f4);
                f3 = f4;
            }
        } else {
            float f5 = instrument.round(instrument.getBidPrice() - 2.0f * (float)instrument.getPointSize());
            if (f3 > f5) {
                this.warning("TradeManager::breakEvenTrail() too close to bid price setting 2 pts away: " + instrument.getSymbol() + " breakEven: " + f5);
                f3 = f5;
            }
        }
        if (this.isLong() && order.getStopPrice().floatValue() >= f3 || !this.isLong() && order.getStopPrice().floatValue() <= f3) {
            return;
        }
        order.setAdjStopPrice(Float.valueOf(f3));
        orderContext.submitOrders(new Order[]{order});
    }

    private void b(OrderContext orderContext) {
        float f2;
        float f3;
        if (this.b) {
            this.warning("TradeManager::createExitOrders() orders already created!");
            return;
        }
        this.b = true;
        float f4 = (float)(this.getSettings().getDouble(i) * orderContext.getInstrument().getPointSize());
        float f5 = orderContext.getAvgEntryPrice();
        f5 = this.isLong() ? (f5 -= f4) : (f5 += f4);
        Instrument instrument = orderContext.getInstrument();
        if (this.isLong()) {
            f3 = instrument.round(instrument.getSellPrice() - (float)instrument.getPointSize());
            if (f5 > f3) {
                f5 = f3;
            }
        } else {
            f3 = instrument.round(instrument.getBuyPrice() + (float)instrument.getPointSize());
            if (f5 < f3) {
                f5 = f3;
            }
        }
        Enums.OrderAction orderAction = this.isLong() ? Enums.OrderAction.SELL : Enums.OrderAction.BUY;
        ArrayList<Order> arrayList = new ArrayList<Order>();
        Enums.TIF tIF = this.getSettings().getTIF(b);
        Order order = this.a;
        ExitPoint exitPoint = this.getSettings().getExitPoint(c);
        float f6 = (float)exitPoint.getLots() * instrument.getDefaultQuantityAsFloat();
        float f7 = 0.0f;
        f7 = this.isLong() ? instrument.round(orderContext.getAvgEntryPrice() + (float)exitPoint.getPips() * (float)instrument.getPointSize()) : instrument.round(orderContext.getAvgEntryPrice() - (float)exitPoint.getPips() * (float)instrument.getPointSize());
        Object object = this.b != null ? this.b.getReferenceID() : null;
        this.i = orderContext.createLimitOrder(instrument, object, orderAction, tIF, f6, f7);
        arrayList.add(this.i);
        exitPoint = this.getSettings().getExitPoint(d);
        if (exitPoint.isEnabled()) {
            f6 = (float)exitPoint.getLots() * instrument.getDefaultQuantityAsFloat();
            f2 = 0.0f;
            f2 = this.isLong() ? instrument.round(orderContext.getAvgEntryPrice() + (float)exitPoint.getPips() * (float)instrument.getPointSize()) : instrument.round(orderContext.getAvgEntryPrice() - (float)exitPoint.getPips() * (float)instrument.getPointSize());
            object = this.c != null ? this.c.getReferenceID() : null;
            this.j = orderContext.createLimitOrder(instrument, object, orderAction, tIF, f6, f2);
            arrayList.add(this.j);
        }
        if ((exitPoint = this.getSettings().getExitPoint(e)).isEnabled()) {
            f6 = (float)exitPoint.getLots() * instrument.getDefaultQuantityAsFloat();
            f2 = 0.0f;
            f2 = this.isLong() ? instrument.round(orderContext.getAvgEntryPrice() + (float)exitPoint.getPips() * (float)instrument.getPointSize()) : instrument.round(orderContext.getAvgEntryPrice() - (float)exitPoint.getPips() * (float)instrument.getPointSize());
            object = this.d != null ? this.d.getReferenceID() : null;
            this.k = orderContext.createLimitOrder(instrument, object, orderAction, tIF, f6, f2);
            arrayList.add(this.k);
        }
        this.a = false;
        if (order != null) {
            f6 = (float)this.getSettings().getInteger(a).intValue() * instrument.getDefaultQuantityAsFloat();
            this.e = orderContext.createStopOrder(instrument, orderAction, tIF, f6, f5);
            arrayList.add(this.e);
        } else {
            f6 = (float)this.getSettings().getExitPoint(c).getLots() * instrument.getDefaultQuantityAsFloat();
            this.f = orderContext.createStopOrder(instrument, this.b.getReferenceID(), orderAction, tIF, f6, f5);
            arrayList.add(this.f);
            if (this.c != null) {
                f6 = (float)this.getSettings().getExitPoint(d).getLots() * instrument.getDefaultQuantityAsFloat();
                this.g = orderContext.createStopOrder(instrument, this.c.getReferenceID(), orderAction, tIF, f6, f5);
                arrayList.add(this.g);
            }
            if (this.d != null) {
                f6 = (float)this.getSettings().getExitPoint(e).getLots() * instrument.getDefaultQuantityAsFloat();
                this.h = orderContext.createStopOrder(instrument, this.d.getReferenceID(), orderAction, tIF, f6, f5);
                arrayList.add(this.h);
            }
        }
        orderContext.submitOrders(arrayList);
    }

    private void c(OrderContext orderContext) {
        float f2;
        if (!this.a) {
            return;
        }
        if (!(this.a(this.e) || this.a(this.f) || this.a(this.g) || this.a(this.h))) {
            return;
        }
        DataContext dataContext = orderContext.getDataContext();
        DataSeries dataSeries = dataContext.getDataSeries();
        Instrument instrument = dataContext.getInstrument();
        int n2 = dataSeries.size() - 1;
        int n3 = this.getSettings().getInteger(j);
        double d2 = this.getSettings().getDouble(k);
        Double d3 = dataSeries.atr(n2 - 1, n3);
        if (d3 == null) {
            return;
        }
        float f3 = (float)instrument.round(d3 * d2);
        boolean bl2 = true;
        if (this.a(this.e)) {
            bl2 = this.e.isBuy();
        }
        if (this.a(this.f)) {
            bl2 = this.f.isBuy();
        }
        float f4 = dataSeries.getClose(n2 - 1);
        float f5 = 0.0f;
        if (bl2) {
            f5 = instrument.round(f4 + f3);
            if (f5 < (f2 = instrument.round(instrument.getAskPrice() + 2.0f * (float)instrument.getPointSize()))) {
                f5 = f2;
            }
        } else {
            f5 = instrument.round(f4 - f3);
            if (f5 > (f2 = instrument.round(instrument.getBidPrice() - 2.0f * (float)instrument.getPointSize()))) {
                f5 = f2;
            }
        }
        double d4 = 0.0;
        if (this.a(this.e)) {
            d4 = this.e.getStopPrice().floatValue();
        } else if (this.a(this.f)) {
            d4 = this.f.getStopPrice().floatValue();
        } else if (this.a(this.g)) {
            d4 = this.g.getStopPrice().floatValue();
        } else if (this.a(this.h)) {
            d4 = this.h.getStopPrice().floatValue();
        }
        if (bl2 && (double)f5 >= d4 || !bl2 && (double)f5 <= d4) {
            return;
        }
        if (this.a(this.e)) {
            this.e.setAdjStopPrice(Float.valueOf(f5));
            orderContext.submitOrders(new Order[]{this.e});
        } else {
            ArrayList<Order> arrayList = new ArrayList<Order>();
            if (this.a(this.f)) {
                this.f.setAdjStopPrice(Float.valueOf(f5));
                arrayList.add(this.f);
            }
            if (this.a(this.g)) {
                this.g.setAdjStopPrice(Float.valueOf(f5));
                arrayList.add(this.g);
            }
            if (this.a(this.h)) {
                this.h.setAdjStopPrice(Float.valueOf(f5));
                arrayList.add(this.h);
            }
            orderContext.submitOrders(arrayList);
        }
    }

    private void b(OrderContext orderContext, Order order) {
        ArrayList<Order> arrayList = new ArrayList<Order>();
        if (this.a(this.i) && Util.isEmpty((Object)this.i.getReferenceID())) {
            arrayList.add(this.i);
        }
        if (this.a(this.j) && Util.isEmpty((Object)this.j.getReferenceID())) {
            arrayList.add(this.j);
        }
        if (this.a(this.k) && Util.isEmpty((Object)this.k.getReferenceID())) {
            arrayList.add(this.k);
        }
        this.k = null;
        this.j = null;
        this.i = null;
        orderContext.cancelOrders(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(OrderContext orderContext) {
        try {
            if (this.e != null) {
                float f2 = this.i.getFilledAsFloat();
                if (f2 == 0.0f) {
                    this.warning("TradeManager::firstExitFilled() filled qty is 0!");
                    f2 = (float)this.getSettings().getExitPoint(c).getLots() * orderContext.getInstrument().getDefaultQuantityAsFloat();
                }
                if (f2 >= this.e.getQuantityAsFloat()) {
                    ArrayList<Order> arrayList = new ArrayList<Order>();
                    if (Util.isEmpty((Object)this.e.getReferenceID())) {
                        arrayList.add(this.e);
                    }
                    if (this.j != null) {
                        arrayList.add(this.j);
                    }
                    if (this.k != null) {
                        arrayList.add(this.k);
                    }
                    orderContext.cancelOrders(arrayList);
                } else {
                    this.e.setAdjQuantity(this.e.getQuantityAsFloat() - f2);
                    orderContext.submitOrders(new Order[]{this.e});
                }
            } else if (this.f != null && Util.isEmpty((Object)this.f.getReferenceID())) {
                orderContext.cancelOrders(new Order[]{this.f});
            }
        }
        finally {
            this.i = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(OrderContext orderContext) {
        try {
            if (this.e != null) {
                float f2 = this.j.getFilledAsFloat();
                if (f2 == 0.0f) {
                    this.warning("TradeManager::secondExitFilled() filled qty is 0!");
                    f2 = (float)this.getSettings().getExitPoint(d).getLots() * orderContext.getInstrument().getDefaultQuantityAsFloat();
                }
                if (f2 >= this.e.getQuantityAsFloat()) {
                    ArrayList<Order> arrayList = new ArrayList<Order>();
                    if (Util.isEmpty((Object)this.e.getReferenceID())) {
                        arrayList.add(this.e);
                    }
                    if (this.k != null) {
                        arrayList.add(this.k);
                    }
                    orderContext.cancelOrders(arrayList);
                } else {
                    this.e.setAdjQuantity(this.e.getQuantityAsFloat() - f2);
                    orderContext.submitOrders(new Order[]{this.e});
                }
            } else if (this.g != null && Util.isEmpty((Object)this.g.getReferenceID())) {
                orderContext.cancelOrders(new Order[]{this.g});
            }
        }
        finally {
            this.j = null;
        }
    }

    private void f(OrderContext orderContext) {
        try {
            if (this.e != null) {
                if (Util.isEmpty((Object)this.e.getReferenceID())) {
                    orderContext.cancelOrders(new Order[]{this.e});
                }
            } else if (this.h != null && Util.isEmpty((Object)this.h.getReferenceID())) {
                orderContext.cancelOrders(new Order[]{this.h});
            }
        }
        finally {
            this.k = null;
        }
    }

    private void a(Order order) {
        if (order == this.a) {
            this.a = null;
        }
        if (order == this.b) {
            this.b = null;
        }
        if (order == this.c) {
            this.c = null;
        }
        if (order == this.d) {
            this.d = null;
        }
        if (order == this.i) {
            this.i = null;
        }
        if (order == this.j) {
            this.j = null;
        }
        if (order == this.k) {
            this.k = null;
        }
        if (order == this.e) {
            this.e = null;
        }
        if (order == this.f) {
            this.f = null;
        }
        if (order == this.g) {
            this.g = null;
        }
        if (order == this.h) {
            this.h = null;
        }
    }

    private boolean a(Order order) {
        if (order == null) {
            return false;
        }
        if (!order.exists()) {
            return false;
        }
        return !order.isCancelled() && !order.isFilled();
    }
}

