/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.WilliamsR$Signals;
import com.motivewave.platform.study.general.WilliamsR$Values;

@StudyHeader(namespace="com.motivewave", id="WILL_R", rb="com.motivewave.platform.study.nls.strings", name="TITLE_WILL_R", tabName="TAB_WILL_R", desc="DESC_WILL_R", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/williams_r.htm")
public class WilliamsR
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), -20.0, -100.0, 0.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), -50.0, -100.0, 0.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), -80.0, -100.0, 0.0, 1.0, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)WilliamsR$Values.R, this.get("VAL_WILL_R", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)WilliamsR$Values.R, "line");
        runtimeDescriptor.declareIndicator((Object)WilliamsR$Values.R, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{WilliamsR$Values.R});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(-90));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(-10));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.declareSignal((Object)WilliamsR$Signals.R_TOP, this.get("LBL_R_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)WilliamsR$Signals.R_BOTTOM, this.get("LBL_R_BOTTOM", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        double d2 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d3 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        double d4 = (d2 - (double)dataSeries.getClose(n2)) / (d2 - d3) * -100.0;
        dataSeries.setDouble(n2, (Object)WilliamsR$Values.R, Double.valueOf(d4));
        dataSeries.setComplete(n2);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        d4 = this.round(d4);
        if (this.crossedAbove(dataSeries, n2, (Object)WilliamsR$Values.R, guideInfo.getValue())) {
            dataContext.signal(n2, (Object)WilliamsR$Signals.R_TOP, this.get("SIGNAL_R_TOP", new Object[]{d4, guideInfo.getValue()}), (Object)d4);
        } else if (this.crossedBelow(dataSeries, n2, (Object)WilliamsR$Values.R, guideInfo2.getValue())) {
            dataContext.signal(n2, (Object)WilliamsR$Signals.R_BOTTOM, this.get("SIGNAL_R_BOTTOM", new Object[]{d4, guideInfo2.getValue()}), (Object)d4);
        }
    }
}

