/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.TwiggsMoneyFlow$Signals;
import com.motivewave.platform.study.general.TwiggsMoneyFlow$Values;

@StudyHeader(namespace="com.motivewave", id="ID_TMF", rb="com.motivewave.platform.study.nls.strings2", name="NAME_TWIGGS_MONEY_FLOW", label="LBL_TMF", desc="DESC_TMF", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/twiggs_money_flow.htm", overlay=false, signals=true, requiresVolume=true, studyOverlay=true)
public class TwiggsMoneyFlow
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 21, 1, 500, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_TMF", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup3);
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.2, 0.0, 3.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -3.001, 3.001, 0.001, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.2, -3.001, 0.0, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TwiggsMoneyFlow$Values.TMF, this.get("TMF", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TwiggsMoneyFlow$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TwiggsMoneyFlow$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)TwiggsMoneyFlow$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TwiggsMoneyFlow$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)TwiggsMoneyFlow$Values.TMF, "line");
        runtimeDescriptor.declareIndicator((Object)TwiggsMoneyFlow$Values.TMF, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{TwiggsMoneyFlow$Values.TMF});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getVolume(n2);
        double d4 = dataSeries.getClose(n2);
        double d5 = dataSeries.getHigh(n2);
        double d6 = dataSeries.getLow(n2);
        double d7 = dataSeries.getClose(n2 - 1);
        double d8 = Math.max(d5, d7);
        double d9 = Math.min(d6, d7);
        d2 = d9 == d8 ? 0.0 : (d4 - d9 - (d8 - d4)) / (d8 - d9) * d3;
        dataSeries.setDouble(n2, (Object)TwiggsMoneyFlow$Values.AD, Double.valueOf(d2));
        if (n2 < n3 + 1) {
            return;
        }
        Double d10 = dataSeries.ma(mAMethod, n2, n3, (Object)TwiggsMoneyFlow$Values.AD);
        Double d11 = dataSeries.ma(mAMethod, n2, n3, (Object)Enums.BarInput.VOLUME);
        if (d10 == null || d11 == null) {
            return;
        }
        if (d11 == 0.0) {
            return;
        }
        double d12 = d10 / d11;
        dataSeries.setDouble(n2, (Object)TwiggsMoneyFlow$Values.TMF, Double.valueOf(d12));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        double d15 = dataSeries.getDouble(n2 - 1, (Object)TwiggsMoneyFlow$Values.TMF, 0.0);
        boolean bl2 = d12 > d13 && d15 > d12 && d12 > this.a;
        boolean bl3 = d12 < d14 && d15 < d12 && d12 < this.b;
        dataSeries.setBoolean(n2, (Object)TwiggsMoneyFlow$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)TwiggsMoneyFlow$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_CLOSE_TWIGGS_MONEY_FLOW", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TwiggsMoneyFlow$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_CLOSE_TWIGGS_MONEY_FLOW", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TwiggsMoneyFlow$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

