/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SupportResistanceOsc$Signals;
import com.motivewave.platform.study.general.SupportResistanceOsc$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_SRO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_SUPPORT_AND_RESISTANCE_OSC", label="LBL_SRO", desc="DESC_SRO", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/supportandresistance_oscillator.htm", overlay=false, signals=true, studyOverlay=true)
public class SupportResistanceOsc
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getBlue(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.7, 0.0, 1.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.5, 0.0, 1.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 0.3, 0.0, 1.01, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistanceOsc$Values.SRO, this.get("SRO", new Object[0]), new String[]{"input"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistanceOsc$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SupportResistanceOsc$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareBars((Object)SupportResistanceOsc$Values.SRO);
        runtimeDescriptor.declareIndicator((Object)SupportResistanceOsc$Values.SRO, "ind");
        runtimeDescriptor.declareSignal((Object)SupportResistanceOsc$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SupportResistanceOsc$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{SupportResistanceOsc$Values.SRO});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = 0.0;
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getOpen(n2);
        double d6 = dataSeries.getDouble(n2, object, 0.0);
        double d7 = dataSeries.getTrueRange(n2).floatValue();
        if (d7 != 0.0) {
            d2 = (d3 - d5 + (d6 - d4)) / (2.0 * d7);
        }
        dataSeries.setDouble(n2, (Object)SupportResistanceOsc$Values.SRO, Double.valueOf(d2));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d8 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d9 = guideInfo2.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("neutralColor");
        Color color3 = this.getSettings().getColor("downColor");
        dataSeries.setBarColor(n2, (Object)SupportResistanceOsc$Values.SRO, color2);
        if (d2 > d8) {
            dataSeries.setBarColor(n2, (Object)SupportResistanceOsc$Values.SRO, color);
        }
        if (d2 < d9) {
            dataSeries.setBarColor(n2, (Object)SupportResistanceOsc$Values.SRO, color3);
        }
        boolean bl2 = d2 > d8 && d2 > this.a;
        boolean bl3 = d2 < d9 && d2 < this.b;
        dataSeries.setBoolean(n2, (Object)SupportResistanceOsc$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)SupportResistanceOsc$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d2;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_SRO", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d2, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SupportResistanceOsc$Signals.SELL, string, (Object)d3);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d2;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_SRO", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d2, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SupportResistanceOsc$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

