/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.StochasticSC$Signals;
import com.motivewave.platform.study.general.StochasticSC$Values;

@StudyHeader(namespace="com.motivewave", id="ID_STSC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_STSC", name="NAME_STOCHASTIC_SC", desc="DESC_STSC", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/stochastics_sc.htm", signals=true, overlay=false, studyOverlay=true)
public class StochasticSC
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FAST_K_PERIOD", new Object[0]), 7, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("CUSTOM_K_PERIOD", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("CUSTOM_D_PERIOD", new Object[0]), 12, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("CUSTOM_K", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("CUSTOM_D", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("CUSTOM_K", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("CUSTOM_D", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticSC$Values.SCK, this.get("LBL_TBSTF", new Object[0]), new String[]{"input", "period", "period2", "period3", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticSC$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticSC$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)StochasticSC$Values.SCK, "line");
        runtimeDescriptor.declarePath((Object)StochasticSC$Values.SCD, "line2");
        runtimeDescriptor.declareIndicator((Object)StochasticSC$Values.SCK, "ind");
        runtimeDescriptor.declareIndicator((Object)StochasticSC$Values.SCD, "ind2");
        runtimeDescriptor.declareSignal((Object)StochasticSC$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticSC$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{StochasticSC$Values.SCK, StochasticSC$Values.SCD});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 + n3 + n4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d5 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        double d6 = d4 - d5;
        double d7 = d3 - d5;
        double d8 = d6;
        dataSeries.setDouble(n2, (Object)StochasticSC$Values.NUM, Double.valueOf(d7));
        dataSeries.setDouble(n2, (Object)StochasticSC$Values.DEN, Double.valueOf(d8));
        if (n2 < n3 + n4) {
            return;
        }
        double d9 = dataSeries.sma(n2, n4, (Object)StochasticSC$Values.NUM);
        double d10 = dataSeries.sma(n2, n4, (Object)StochasticSC$Values.DEN);
        if (d6 > 0.0) {
            d2 = n4 <= 1 ? d7 / d8 * 100.0 : d9 / d10 * 100.0;
        }
        dataSeries.setDouble(n2, (Object)StochasticSC$Values.SCK, Double.valueOf(d2));
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod, n2, n5, (Object)StochasticSC$Values.SCK);
        dataSeries.setDouble(n2, (Object)StochasticSC$Values.SCD, d11);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d12 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d13 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)StochasticSC$Values.SCK, (Object)StochasticSC$Values.SCD) && d2 > d12 && d2 > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)StochasticSC$Values.SCK, (Object)StochasticSC$Values.SCD) && d2 < d13 && d2 < this.b;
        dataSeries.setBoolean(n2, (Object)StochasticSC$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)StochasticSC$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d2;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_STSC", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d2, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StochasticSC$Signals.SELL, string, (Object)d3);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d2;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d2);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_STSC", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d2, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StochasticSC$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

