/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.StochasticFull$Signals;
import com.motivewave.platform.study.general.StochasticFull$Values;

@StudyHeader(namespace="com.motivewave", id="STO_FULL", rb="com.motivewave.platform.study.nls.strings", name="TITLE_STO_FULL", label="LBL_STO_FULL", desc="DESC_STO_FULL", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/stochastic_full.htm")
public class StochasticFull
extends Study {
    static final String a = "kLine";
    static final String b = "dLine";
    static final String c = "kInd";
    static final String d = "dInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_K_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_K_FULL_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("LBL_D_FULL_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_K_FULL_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("LBL_D_FULL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("LBL_K_FULL_IND", new Object[0]), null, null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("LBL_D_FULL_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 80.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticFull$Values.P_K, this.get("LBL_K_FULL", new Object[0]), new String[]{"period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticFull$Values.P_D, this.get("LBL_D_FULL", new Object[0]), new String[]{"period", "period2", "period3"}));
        runtimeDescriptor.declarePath((Object)StochasticFull$Values.P_K, a);
        runtimeDescriptor.declarePath((Object)StochasticFull$Values.P_D, b);
        runtimeDescriptor.declareIndicator((Object)StochasticFull$Values.P_K, c);
        runtimeDescriptor.declareIndicator((Object)StochasticFull$Values.P_D, d);
        runtimeDescriptor.declareSignal((Object)StochasticFull$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticFull$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticFull$Signals.PK_TOP, this.get("LBL_PK_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticFull$Signals.PK_BOTTOM, this.get("LBL_PK_BOTTOM", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{StochasticFull$Values.P_K, StochasticFull$Values.P_D});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(10));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(90));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected int b() {
        return this.getSettings().getInteger("period");
    }

    protected int a() {
        return this.getSettings().getInteger("period2");
    }

    protected int c() {
        return this.getSettings().getInteger("period3");
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object;
        MarkerInfo markerInfo;
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.b();
        Double d2 = dataSeries.stochasticK(n2, n3);
        dataSeries.setDouble(n2, (Object)StochasticFull$Values.K, d2);
        int n4 = this.a();
        int n5 = this.c();
        if (n2 < n3 + n4) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Double d3 = dataSeries.ma(mAMethod, n2, n4, (Object)StochasticFull$Values.K);
        dataSeries.setDouble(n2, (Object)StochasticFull$Values.P_K, d3);
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d4 = dataSeries.ma(mAMethod, n2, n5, (Object)StochasticFull$Values.P_K);
        dataSeries.setDouble(n2, (Object)StochasticFull$Values.P_D, d4);
        if (!dataSeries.isBarComplete(n2) || d4 == null) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d4.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)StochasticFull$Values.P_K, (Object)StochasticFull$Values.P_D)) {
            markerInfo = this.getSettings().getMarker("upMarker");
            object = this.get("SIGNAL_STO_CROSS_ABOVE", new Object[]{d3, d4});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, (String)object));
            }
            dataContext.signal(n2, (Object)StochasticFull$Signals.CROSS_ABOVE, (String)object, (Object)d4);
        } else if (this.crossedBelow(dataSeries, n2, (Object)StochasticFull$Values.P_K, (Object)StochasticFull$Values.P_D)) {
            markerInfo = this.getSettings().getMarker("downMarker");
            object = this.get("SIGNAL_STO_CROSS_BELOW", new Object[]{d3, d4});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, (String)object));
            }
            dataContext.signal(n2, (Object)StochasticFull$Signals.CROSS_BELOW, (String)object, (Object)d4);
        }
        markerInfo = this.getSettings().getGuide("topGuide");
        object = this.getSettings().getGuide("bottomGuide");
        if (this.crossedAbove(dataSeries, n2, (Object)StochasticFull$Values.P_K, markerInfo.getValue())) {
            dataContext.signal(n2, (Object)StochasticFull$Signals.PK_TOP, this.get("SIGNAL_PK_TOP", new Object[]{this.round(d3), markerInfo.getValue()}), (Object)this.round(d3));
        } else if (this.crossedBelow(dataSeries, n2, (Object)StochasticFull$Values.P_K, object.getValue())) {
            dataContext.signal(n2, (Object)StochasticFull$Signals.PK_BOTTOM, this.get("SIGNAL_PK_BOTTOM", new Object[]{this.round(d3), object.getValue()}), (Object)this.round(d3));
        }
        dataSeries.setComplete(n2);
    }
}

